/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.operator.window.matcher.Done;
import io.trino.operator.window.matcher.Instruction;
import io.trino.operator.window.matcher.IrRowPatternToProgramRewriter;
import io.trino.operator.window.matcher.Jump;
import io.trino.operator.window.matcher.MatchEnd;
import io.trino.operator.window.matcher.MatchLabel;
import io.trino.operator.window.matcher.MatchStart;
import io.trino.operator.window.matcher.Program;
import io.trino.operator.window.matcher.Save;
import io.trino.operator.window.matcher.Split;
import io.trino.sql.planner.rowpattern.Patterns;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIrRowPatternToProgramRewriter {
    private static final Map<IrLabel, Integer> LABEL_MAPPING = ImmutableMap.of((Object)new IrLabel("A"), (Object)0, (Object)new IrLabel("B"), (Object)1, (Object)new IrLabel("C"), (Object)2, (Object)new IrLabel("D"), (Object)3, (Object)new IrLabel("E"), (Object)4);

    @Test
    public void testPatternLabel() {
        this.assertRewritten((IrRowPattern)Patterns.label("A"), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new Done()));
    }

    @Test
    public void testEmptyPattern() {
        this.assertRewritten(Patterns.empty(), (List<Instruction>)ImmutableList.of((Object)new Done()));
    }

    @Test
    public void testAnchorPattern() {
        this.assertRewritten(Patterns.start(), (List<Instruction>)ImmutableList.of((Object)new MatchStart(), (Object)new Done()));
        this.assertRewritten(Patterns.end(), (List<Instruction>)ImmutableList.of((Object)new MatchEnd(), (Object)new Done()));
    }

    @Test
    public void testPatternExclusion() {
        this.assertRewritten(Patterns.excluded((IrRowPattern)Patterns.label("A")), (List<Instruction>)ImmutableList.of((Object)new Save(), (Object)new MatchLabel(0), (Object)new Save(), (Object)new Done()));
    }

    @Test
    public void testPatternAlternation() {
        this.assertRewritten(Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), (List<Instruction>)ImmutableList.of((Object)new Split(1, 3), (Object)new MatchLabel(0), (Object)new Jump(4), (Object)new MatchLabel(1), (Object)new Done()));
        this.assertRewritten(Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C"), Patterns.label("D")}), (List<Instruction>)ImmutableList.of((Object)new Split(1, 3), (Object)new MatchLabel(0), (Object)new Jump(10), (Object)new Split(4, 6), (Object)new MatchLabel(1), (Object)new Jump(10), (Object)new Split(7, 9), (Object)new MatchLabel(2), (Object)new Jump(10), (Object)new MatchLabel(3), (Object)new Done()));
    }

    @Test
    public void testPatternConcatenation() {
        this.assertRewritten(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(1), (Object)new Done()));
        this.assertRewritten(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C"), Patterns.label("D")}), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(1), (Object)new MatchLabel(2), (Object)new MatchLabel(3), (Object)new Done()));
    }

    @Test
    public void testPatternPermutation() {
        this.assertRewritten(Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), (List<Instruction>)ImmutableList.of((Object)new Split(1, 4), (Object)new MatchLabel(0), (Object)new MatchLabel(1), (Object)new Jump(6), (Object)new MatchLabel(1), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}), (List<Instruction>)ImmutableList.of((Object)new Split(1, 5), (Object)new MatchLabel(0), (Object)new MatchLabel(1), (Object)new MatchLabel(2), (Object)new Jump(28), (Object)new Split(6, 10), (Object)new MatchLabel(0), (Object)new MatchLabel(2), (Object)new MatchLabel(1), (Object)new Jump(28), (Object)new Split(11, 15), (Object)new MatchLabel(1), (Object[])new Instruction[]{new MatchLabel(0), new MatchLabel(2), new Jump(28), new Split(16, 20), new MatchLabel(1), new MatchLabel(2), new MatchLabel(0), new Jump(28), new Split(21, 25), new MatchLabel(2), new MatchLabel(0), new MatchLabel(1), new Jump(28), new MatchLabel(2), new MatchLabel(1), new MatchLabel(0), new Done()}));
    }

    @Test
    public void testQuantifiers() {
        this.assertRewritten(Patterns.starQuantified((IrRowPattern)Patterns.label("A"), true), (List<Instruction>)ImmutableList.of((Object)new Split(1, 3), (Object)new MatchLabel(0), (Object)new Split(1, 3), (Object)new Done()));
        this.assertRewritten(Patterns.starQuantified((IrRowPattern)Patterns.label("A"), false), (List<Instruction>)ImmutableList.of((Object)new Split(3, 1), (Object)new MatchLabel(0), (Object)new Split(3, 1), (Object)new Done()));
        this.assertRewritten(Patterns.plusQuantified((IrRowPattern)Patterns.label("A"), true), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new Split(0, 2), (Object)new Done()));
        this.assertRewritten(Patterns.plusQuantified((IrRowPattern)Patterns.label("A"), false), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new Split(2, 0), (Object)new Done()));
        this.assertRewritten(Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("A"), true), (List<Instruction>)ImmutableList.of((Object)new Split(1, 2), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("A"), false), (List<Instruction>)ImmutableList.of((Object)new Split(2, 1), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 0, Optional.empty(), true), (List<Instruction>)ImmutableList.of((Object)new Split(1, 3), (Object)new MatchLabel(0), (Object)new Split(1, 3), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 0, Optional.empty(), false), (List<Instruction>)ImmutableList.of((Object)new Split(3, 1), (Object)new MatchLabel(0), (Object)new Split(3, 1), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 3, Optional.empty(), true), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new Split(2, 4), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 3, Optional.empty(), false), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new Split(4, 2), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 0, Optional.of(3), true), (List<Instruction>)ImmutableList.of((Object)new Split(1, 6), (Object)new MatchLabel(0), (Object)new Split(3, 6), (Object)new MatchLabel(0), (Object)new Split(5, 6), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 0, Optional.of(3), false), (List<Instruction>)ImmutableList.of((Object)new Split(6, 1), (Object)new MatchLabel(0), (Object)new Split(6, 3), (Object)new MatchLabel(0), (Object)new Split(6, 5), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 3, Optional.of(3), true), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 3, Optional.of(3), false), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 0, Optional.of(0), true), (List<Instruction>)ImmutableList.of((Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 0, Optional.of(0), false), (List<Instruction>)ImmutableList.of((Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 2, Optional.of(4), true), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new Split(3, 6), (Object)new MatchLabel(0), (Object)new Split(5, 6), (Object)new MatchLabel(0), (Object)new Done()));
        this.assertRewritten(Patterns.rangeQuantified((IrRowPattern)Patterns.label("A"), 2, Optional.of(4), false), (List<Instruction>)ImmutableList.of((Object)new MatchLabel(0), (Object)new MatchLabel(0), (Object)new Split(6, 3), (Object)new MatchLabel(0), (Object)new Split(6, 5), (Object)new MatchLabel(0), (Object)new Done()));
    }

    private void assertRewritten(IrRowPattern pattern, List<Instruction> expected) {
        Program program = IrRowPatternToProgramRewriter.rewrite((IrRowPattern)pattern, LABEL_MAPPING);
        Assert.assertEquals((Collection)program.getInstructions(), expected);
    }
}

