/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.interval;

import io.trino.sql.query.QueryAssertions;
import io.trino.type.SqlIntervalDayTime;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIntervalDayTime {
    protected QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45:32.123' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45:32.12' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45:32' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 32, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45' DAY TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10' DAY TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10' DAY TO HOUR")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY TO HOUR")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '30' DAY")))).isEqualTo(TestIntervalDayTime.interval(30, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '90' DAY")))).isEqualTo(TestIntervalDayTime.interval(90, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45:32.123' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45:32.12' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45:32' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 32, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45' HOUR TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10' HOUR TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10' HOUR")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45:32.123' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45:32.12' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45:32' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 32, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45' MINUTE")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32.123' SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 0, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32.12' SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 0, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32' SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 0, 32, 0));
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12X' DAY")::evaluate).hasMessage("line 1:12: '12X' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12 10' DAY")::evaluate).hasMessage("line 1:12: '12 10' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12 X' DAY TO HOUR")::evaluate).hasMessage("line 1:12: '12 X' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12 -10' DAY TO HOUR")::evaluate).hasMessage("line 1:12: '12 -10' is not a valid INTERVAL literal");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '--12 -10' DAY TO HOUR")::evaluate).hasMessage("line 1:12: '--12 -10' is not a valid INTERVAL literal");
    }

    private static SqlIntervalDayTime interval(int day, int hour, int minute, int second, int milliseconds) {
        return new SqlIntervalDayTime(day, hour, minute, second, milliseconds);
    }
}

