/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestWordStemFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testWordStem() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'x'")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("x");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'abc'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'generally'")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("general");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'useful'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("use");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'runs'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("run");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'run'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("run");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'authorized'", "'en'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("author");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'accessories'", "'en'")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("accessori");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'intensifying'", "'en'")))).hasType((Type)VarcharType.createVarcharType((int)12)).isEqualTo("intensifi");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'resentment'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("resent");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'faithfulness'")))).hasType((Type)VarcharType.createVarcharType((int)12)).isEqualTo("faith");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'continuerait'", "'fr'")))).hasType((Type)VarcharType.createVarcharType((int)12)).isEqualTo("continu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'torpedearon'", "'es'")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("torped");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'quilomtricos'", "'pt'")))).hasType((Type)VarcharType.createVarcharType((int)12)).isEqualTo("quilomtr");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'pronunziare'", "'it'")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("pronunz");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'auferstnde'", "'de'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("auferstnd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'\u00e3'", "'pt'")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("\u00e3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("word_stem", "'bast\u00e3o'", "'pt'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("bast\u00e3");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("word_stem", "'test'", "'xx'")::evaluate).hasMessage("Unknown stemmer language: xx");
    }
}

