/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.StructuralTestUtil;
import java.util.Collections;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestStringFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(this.getClass()).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Description(value="Varchar length")
    @ScalarFunction(value="vl", deterministic=true)
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long varcharLength(@LiteralParameter(value="x") Long param, @SqlType(value="varchar(x)") Slice slice) {
        return param;
    }

    @ScalarFunction(value="utf8", deterministic=false)
    @SqlType(value="varchar")
    public static Slice convertBinaryToVarchar(@SqlType(value="varbinary") Slice binary) {
        return binary;
    }

    public static String padRight(String s, int n) {
        return s + " ".repeat(n - s.codePointCount(0, s.length()));
    }

    @Test
    public void testChr() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("chr", "65")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("A");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("chr", "9731")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("\u2603");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("chr", "131210")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo(new String(Character.toChars(131210)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("chr", "0")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("\u0000");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("chr", "-1")::evaluate).hasMessage("Not a valid Unicode code point: -1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("chr", "1234567")::evaluate).hasMessage("Not a valid Unicode code point: 1234567");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("chr", "8589934592")::evaluate).hasMessage("Not a valid Unicode code point: 8589934592");
    }

    @Test
    public void testCodepoint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("codepoint", "'x'")))).hasType((Type)IntegerType.INTEGER).isEqualTo(120);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("codepoint", "'\u840c'")))).hasType((Type)IntegerType.INTEGER).isEqualTo(33804);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("codepoint", "CHR(128077)")))).hasType((Type)IntegerType.INTEGER).isEqualTo(128077);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("codepoint", "CHR(33804)")))).hasType((Type)IntegerType.INTEGER).isEqualTo(33804);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("codepoint", "'hello'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("codepoint", "'\u666e\u5217\u65af\u6258'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("codepoint", "''")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testConcat() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("concat", "''")::evaluate).hasMessage("There must be two or more concatenation arguments");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'hello'", "' world'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "''", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'what'", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("what");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "''", "'what'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("what");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'this'", "' is'", "' cool'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("this is cool");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'this'", "' is'", "' cool'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("this is cool");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'hello na\u00efve'", "' world'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("hello na\u00efve world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'\ud801\udc2d'", "'end'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\ud801\udc2dend");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'\ud801\udc2d'", "'end'", "'\ud801\udc2d'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\ud801\udc2dend\ud801\udc2d");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'\u4fe1\u5ff5'", "',\u7231'", "',\u5e0c\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u4fe1\u5ff5,\u7231,\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(127, "'x'")) + ")")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(Joiner.on((String)"").join(Collections.nCopies(127, "x")));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(128, "'x'")) + ")")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_ARGUMENTS}).hasMessage("line 1:12: Too many arguments for function call concat()");
    }

    @Test
    public void testLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "''")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "'hello'")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "'Quadratically'")))).isEqualTo(13L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "'hello na\u00efve world'")))).isEqualTo(17L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "'\ud801\udc2dend'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'")))).isEqualTo(7L);
    }

    @Test
    public void testCharLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('hello' AS CHAR(5))")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('Quadratically' AS CHAR(13))")))).isEqualTo(13L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('' AS CHAR(20))")))).isEqualTo(20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('hello' AS CHAR(20))")))).isEqualTo(20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('Quadratically' AS CHAR(20))")))).isEqualTo(20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('hello na\u00efve world' AS CHAR(17))")))).isEqualTo(17L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('\ud801\udc2dend' AS CHAR(4))")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7))")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('hello na\u00efve world' AS CHAR(20))")))).isEqualTo(20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('\ud801\udc2dend' AS CHAR(20))")))).isEqualTo(20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(20))")))).isEqualTo(20L);
    }

    @Test
    public void testLevenshteinDistance() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "''", "''")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "''", "'hello'")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello'", "''")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello'", "'hello'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello'", "'hello world'")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello world'", "'hel wold'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello world'", "'hellq wodld'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'helo word'", "'hello world'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello word'", "'dello world'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello na\u00efve world'", "'hello naive world'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello na\u00efve world'", "'hello na:ive world'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u4fe1\u4ef0,\u7231,\u5e0c\u671b'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'\u4f11\u5ff5,\u7231,\u5e0c\u671b'", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u4fe1\u5ff5\u5e0c\u671b'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u4fe1\u5ff5,love,\u5e0c\u671b'")))).isEqualTo(4L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("levenshtein_distance", "'hello world'", "utf8(from_hex('81'))")::evaluate).hasMessage("Invalid UTF-8 encoding in characters: \ufffd");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("levenshtein_distance", "'hello wolrd'", "utf8(from_hex('3281'))")::evaluate).hasMessage("Invalid UTF-8 encoding in characters: 2\ufffd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'hello'", "'%s'".formatted("e".repeat(100000)))))).isEqualTo(99999L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("levenshtein_distance", "'%s'".formatted("l".repeat(100000)), "'hello'")))).isEqualTo(99998L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("levenshtein_distance", "'%s'".formatted("x".repeat(1001)), "'%s'".formatted("x".repeat(1001)))::evaluate).hasMessage("The combined inputs for Levenshtein distance are too large");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("levenshtein_distance", "'hello'", "'%s'".formatted("x".repeat(500000)))::evaluate).hasMessage("The combined inputs for Levenshtein distance are too large");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("levenshtein_distance", "'%s'".formatted("x".repeat(500000)), "'hello'")::evaluate).hasMessage("The combined inputs for Levenshtein distance are too large");
    }

    @Test
    public void testHammingDistance() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "''", "''")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'hello'", "'hello'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'hello'", "'jello'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'like'", "'hate'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'hello'", "'world'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "NULL", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'hello'", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "NULL", "'world'")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'hello na\u00efve world'", "'hello naive world'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u4fe1\u4ef0,\u7231,\u5e0c\u671b'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hamming_distance", "'\u4f11\u5ff5,\u7231,\u5e0c\u671b'", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'")))).isEqualTo(1L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("hamming_distance", "'hello'", "''")::evaluate).hasMessage("The input strings to hamming_distance function must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("hamming_distance", "''", "'hello'")::evaluate).hasMessage("The input strings to hamming_distance function must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("hamming_distance", "'hello'", "'o'")::evaluate).hasMessage("The input strings to hamming_distance function must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("hamming_distance", "'h'", "'hello'")::evaluate).hasMessage("The input strings to hamming_distance function must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("hamming_distance", "'hello na\u00efve world'", "'hello na:ive world'")::evaluate).hasMessage("The input strings to hamming_distance function must have the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("hamming_distance", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u4fe1\u5ff5\u5e0c\u671b'")::evaluate).hasMessage("The input strings to hamming_distance function must have the same length");
    }

    @Test
    public void testReplace() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'aaa'", "'a'", "'aa'")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("aaaaaa");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'abcdefabcdef'", "'cd'", "'XX'")))).hasType((Type)VarcharType.createVarcharType((int)38)).isEqualTo("abXXefabXXef");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'abcdefabcdef'", "'cd'")))).hasType((Type)VarcharType.createVarcharType((int)12)).isEqualTo("abefabef");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'123123tech'", "'123'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("tech");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'123tech123'", "'123'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("tech");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'222tech'", "'2'", "'3'")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("333tech");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'0000123'", "'0'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'0000123'", "'0'", "' '")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("    123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'foo'", "''")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'foo'", "''", "''")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'foo'", "'foo'", "''")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'abc'", "''", "'xx'")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("xxaxxbxxcxx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "''", "''", "'xx'")))).hasType((Type)VarcharType.createVarcharType((int)2)).isEqualTo("xx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "''", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "''", "''", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "','", "'\u2014'")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("\u4fe1\u5ff5\u2014\u7231\u2014\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'::\ud801\udc2d::'", "':'", "''")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("\ud801\udc2d");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("replace", "'\u00d6sterreich'", "'\u00d6'", "'Oe'")))).hasType((Type)VarcharType.createVarcharType((int)32)).isEqualTo("Oesterreich");
    }

    @Test
    public void testReverse() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "'hello'")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("olleh");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "'Quadratically'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("yllacitardauQ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "'racecar'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("racecar");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u671b\u5e0c,\u7231,\u5ff5\u4fe1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "'\u00d6sterreich'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("hcierrets\u00d6");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "'na\u00efve'")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("ev\u00efan");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "'\ud801\udc2dend'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("dne\ud801\udc2d");
    }

    @Test
    public void testStringPosition() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'high'", "'ig'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'ig'").binding("b", "'high'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'high'", "'igx'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'igx'").binding("b", "'high'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'Quadratically'", "'a'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'a'").binding("b", "'Quadratically'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobar'", "'foobar'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'foobar'").binding("b", "'foobar'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobar'", "'obar'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'obar'").binding("b", "'foobar'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'zoo!'", "'!'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'!'").binding("b", "'zoo!'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'x'", "''")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "''").binding("b", "'x'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "''", "''")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "''").binding("b", "''")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u7231'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'\u7231'").binding("b", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u5e0c\u671b'")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'\u5e0c\u671b'").binding("b", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'nice'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "'nice'").binding("b", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "NULL", "''")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "''").binding("b", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "''", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "NULL").binding("b", "''")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "NULL", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("POSITION(a IN b)").binding("a", "NULL").binding("b", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'foo'", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'foo'", "'bar'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'foo'", "''")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "''", "'foo'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "''", "''")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'foo_bar_baz'", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'foo_bar_baz'", "'bar'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'foo'", "'foo_bar_baz'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b'", "'\u4fe1\u5ff5'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("starts_with", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b'", "'\u7231'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "NULL", "''")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "''", "NULL")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "NULL", "NULL")))).isNull((Type)BigintType.BIGINT);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "0")::evaluate).hasMessage("'instance' must be a positive or negative number.");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("strpos", "''", "''", "0")::evaluate).hasMessage("'instance' must be a positive or negative number.");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u7231'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u5e0c\u671b'")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'nice'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'high'", "'ig'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'high'", "'igx'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'Quadratically'", "'a'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobar'", "'foobar'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobar'", "'obar'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'zoo!'", "'!'")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'x'", "''")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "''", "''")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc abc abc'", "'abc'", "1")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "1")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "2")))).isEqualTo(8L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "3")))).isEqualTo(12L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "4")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'highhigh'", "'ig'", "1")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobarfoo'", "'fb'", "1")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobarfoo'", "'oo'", "1")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc abc abc'", "'abc'", "-1")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "-1")))).isEqualTo(12L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "-2")))).isEqualTo(8L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "-3")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'abc/xyz/foo/bar'", "'/'", "-4")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'highhigh'", "'ig'", "-1")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'highhigh'", "'ig'", "-2")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobarfoo'", "'fb'", "-1")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'foobarfoo'", "'oo'", "-1")))).isEqualTo(8L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u7231'", "-1")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u7231\u671b'", "'\u7231'", "-1")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u7231\u671b'", "'\u7231'", "-2")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'\u5e0c\u671b'", "-1")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("strpos", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "'nice'", "-1")))).isEqualTo(0L);
    }

    @Test
    public void testSubstring() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "-5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("cally");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "-50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "0")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "5", "6")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratica");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "5", "10")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "5", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "50", "10")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "-5", "4")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("call");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "-5", "40")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("cally");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "-50", "4")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "0", "4")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "'Quadratically'", "5", "0")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "'Quadratically'").binding("start", "5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "'Quadratically'").binding("start", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "'Quadratically'").binding("start", "-5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("cally");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "'Quadratically'").binding("start", "-50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "'Quadratically'").binding("start", "0")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "'Quadratically'").binding("start", "5").binding("length", "6")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratica");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "'Quadratically'").binding("start", "5").binding("length", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'").binding("start", "1").binding("length", "1")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u4fe1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'").binding("start", "3").binding("length", "5")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo(",\u7231,\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'").binding("start", "4")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u7231,\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'").binding("start", "-2")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "'\ud801\udc2dend'").binding("start", "1").binding("length", "1")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("\ud801\udc2d");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "'\ud801\udc2dend'").binding("start", "2").binding("length", "3")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("end");
    }

    @Test
    public void testCharSubstring() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "-5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("cally");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "-50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "0")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "5", "6")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratica");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "5", "10")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "5", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "50", "10")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "-5", "4")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("call");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "-5", "40")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("cally");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "-50", "4")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "0", "4")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('Quadratically' AS CHAR(13))", "5", "0")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('abc def' AS CHAR(7))", "1", "4")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("abc ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('keep trailing' AS CHAR(14))", "1")))).hasType((Type)VarcharType.createVarcharType((int)14)).isEqualTo("keep trailing ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", "CAST('keep trailing' AS CHAR(14))", "1", "14")))).hasType((Type)VarcharType.createVarcharType((int)14)).isEqualTo("keep trailing ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substring", "CAST('Quadratically' AS CHAR(13))", "5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "CAST('Quadratically' AS CHAR(13))").binding("start", "5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "CAST('Quadratically' AS CHAR(13))").binding("start", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "CAST('Quadratically' AS CHAR(13))").binding("start", "-5")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("cally");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "CAST('Quadratically' AS CHAR(13))").binding("start", "-50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "CAST('Quadratically' AS CHAR(13))").binding("start", "0")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substring", "CAST('Quadratically' AS CHAR(13))", "5", "6")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratica");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "CAST('Quadratically' AS CHAR(13))").binding("start", "5").binding("length", "6")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratica");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "CAST('Quadratically' AS CHAR(13))").binding("start", "5").binding("length", "50")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("ratically");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7))").binding("start", "1").binding("length", "1")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u4fe1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7))").binding("start", "3").binding("length", "5")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo(",\u7231,\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7))").binding("start", "4")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u7231,\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7))").binding("start", "-2")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "CAST('\ud801\udc2dend' AS CHAR(4))").binding("start", "1").binding("length", "1")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("\ud801\udc2d");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "CAST('\ud801\udc2dend' AS CHAR(4))").binding("start", "2").binding("length", "3")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("end");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "CAST('\ud801\udc2dend' AS CHAR(40))").binding("start", "2").binding("length", "3")))).hasType((Type)VarcharType.createVarcharType((int)40)).isEqualTo("end");
    }

    @Test
    public void testSplit() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b.c'", "'.'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'ab'", "'.'", "1")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)2))).isEqualTo(ImmutableList.of((Object)"ab"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b'", "'.'", "1")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"a.b"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b.c'", "'.'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a..b..c'", "'..'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b.c'", "'.'", "2")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b.c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b.c'", "'.'", "3")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b.c'", "'.'", "4")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b.c.'", "'.'", "4")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)6))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b.c.'", "'.'", "3")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)6))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c."));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'...'", "'.'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'..a...a..'", "'.'")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)9))).isEqualTo(ImmutableList.of((Object)"", (Object)"", (Object)"a", (Object)"", (Object)"", (Object)"a", (Object)"", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "','", "3")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"\u4fe1\u5ff5", (Object)"\u7231", (Object)"\u5e0c\u671b"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'\u8b49\u8bc1\u8a3c'", "'\u8bc1'", "2")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"\u8b49", (Object)"\u8a3c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'.a.b.c'", "'.'", "4")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)6))).isEqualTo(ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'.a.b.c'", "'.'", "3")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)6))).isEqualTo(ImmutableList.of((Object)"", (Object)"a", (Object)"b.c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'.a.b.c'", "'.'", "2")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)6))).isEqualTo(ImmutableList.of((Object)"", (Object)"a.b.c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a..b..c'", "'.'", "3")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"a", (Object)"", (Object)"b..c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split", "'a.b..'", "'.'", "3")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)5))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"."));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split", "'a.b.c'", "''", "1")::evaluate).hasMessage("The delimiter may not be the empty string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split", "'a.b.c'", "'.'", "0")::evaluate).hasMessage("Limit must be positive");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split", "'a.b.c'", "'.'", "-1")::evaluate).hasMessage("Limit must be positive");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split", "'a.b.c'", "'.'", "2147483648")::evaluate).hasMessage("Limit is too large");
    }

    @Test
    public void testSplitToMap() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "''", "','", "'='")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "'a=123,b=.4,c=,=d'", "','", "'='")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"a", (Object)"123", (Object)"b", (Object)".4", (Object)"c", (Object)"", (Object)"", (Object)"d"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "'='", "','", "'='")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "'key=>value'", "','", "'=>'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"key", (Object)"value"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "'key => value'", "','", "'=>'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"key ", (Object)" value"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "'\u4ea0\u4eff\u4ea1'", "'\u4e00'", "'\u4eff'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"\u4ea0", (Object)"\u4ea1"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "'\u4ec0\u4eff'", "'\u4e00'", "'\u4eff'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"\u4ec0", (Object)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_map", "'\u4eff\u4ec1'", "'\u4e00'", "'\u4eff'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"", (Object)"\u4ec1"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_map", "''", "'\u4eff'", "'\u4eff'")::evaluate).hasMessage("entryDelimiter and keyValueDelimiter must not be the same");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_map", "'a=123,b=.4,c='", "'='", "'='")::evaluate).hasMessage("entryDelimiter and keyValueDelimiter must not be the same");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_map", "'a=123,a=.4'", "','", "'='")::evaluate).hasMessage("Duplicate keys (a) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_map", "'\u4ea0\u4eff\u4ea1\u4e00\u4ea0\u4eff\u4eb1'", "'\u4e00'", "'\u4eff'")::evaluate).hasMessage("Duplicate keys (\u4ea0) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_map", "'key'", "','", "'='")::evaluate).hasMessage("Key-value delimiter must appear exactly once in each entry. Bad input: 'key'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_map", "'key==value'", "','", "'='")::evaluate).hasMessage("Key-value delimiter must appear exactly once in each entry. Bad input: 'key==value'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_map", "'key=va=lue'", "','", "'='")::evaluate).hasMessage("Key-value delimiter must appear exactly once in each entry. Bad input: 'key=va=lue'");
    }

    @Test
    public void testSplitToMultimap() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "''", "','", "'='")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'a=123,b=.4,c=,=d'", "','", "'='")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"a", (Object)ImmutableList.of((Object)"123"), (Object)"b", (Object)ImmutableList.of((Object)".4"), (Object)"c", (Object)ImmutableList.of((Object)""), (Object)"", (Object)ImmutableList.of((Object)"d")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'='", "','", "'='")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"", (Object)ImmutableList.of((Object)"")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'a=123,a=.4,a=5.67'", "','", "'='")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"a", (Object)ImmutableList.of((Object)"123", (Object)".4", (Object)"5.67")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'key=>value,key=>value'", "','", "'=>'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"key", (Object)ImmutableList.of((Object)"value", (Object)"value")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'key => value, key => value'", "','", "'=>'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"key ", (Object)ImmutableList.of((Object)" value"), (Object)" key ", (Object)ImmutableList.of((Object)" value")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'key => value, key => value'", "', '", "'=>'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"key ", (Object)ImmutableList.of((Object)" value", (Object)" value")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'\u4ea0\u4eff\u4ea1'", "'\u4e00'", "'\u4eff'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"\u4ea0", (Object)ImmutableList.of((Object)"\u4ea1")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_to_multimap", "'\u4ea0\u4eff\u4ea1\u4e00\u4ea0\u4eff\u4eb1'", "'\u4e00'", "'\u4eff'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR))).isEqualTo(ImmutableMap.of((Object)"\u4ea0", (Object)ImmutableList.of((Object)"\u4ea1", (Object)"\u4eb1")));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_multimap", "''", "'\u4eff'", "'\u4eff'")::evaluate).hasMessage("entryDelimiter and keyValueDelimiter must not be the same");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_multimap", "'a=123,b=.4,c='", "'='", "'='")::evaluate).hasMessage("entryDelimiter and keyValueDelimiter must not be the same");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_multimap", "'key'", "','", "'='")::evaluate).hasMessage("Key-value delimiter must appear exactly once in each entry. Bad input: key");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_multimap", "'key==value'", "','", "'='")::evaluate).hasMessage("Key-value delimiter must appear exactly once in each entry. Bad input: key==value");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_to_multimap", "'key=va=lue'", "','", "'='")::evaluate).hasMessage("Key-value delimiter must appear exactly once in each entry. Bad input: key=va=lue");
    }

    @Test
    public void testSplitPart() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-def-@-ghi'", "'-@-'", "1")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-def-@-ghi'", "'-@-'", "2")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-def-@-ghi'", "'-@-'", "3")))).hasType((Type)VarcharType.createVarcharType((int)15)).isEqualTo("ghi");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-def-@-ghi'", "'-@-'", "4")))).isNull((Type)VarcharType.createVarcharType((int)15));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-def-@-ghi'", "'-@-'", "99")))).isNull((Type)VarcharType.createVarcharType((int)15));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "'abc'", "1")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "'abc'", "2")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "'abc'", "3")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "'-@-'", "1")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "'-@-'", "2")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "''", "'abc'", "1")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "''", "''", "1")))).isNull((Type)VarcharType.createVarcharType((int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "''", "1")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("a");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "''", "2")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "''", "3")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("c");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "''", "4")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "''", "99")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "'abcd'", "1")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc'", "'abcd'", "2")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc--@--def'", "'-@-'", "1")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("abc-");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc--@--def'", "'-@-'", "2")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("-def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-@-@-def'", "'-@-'", "1")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-@-@-def'", "'-@-'", "2")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("@");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abc-@-@-@-def'", "'-@-'", "3")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "' '", "' '", "1")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abcdddddef'", "'dd'", "1")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abcdddddef'", "'dd'", "2")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'abcdddddef'", "'dd'", "3")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'a/b/c'", "'/'", "4")))).isNull((Type)VarcharType.createVarcharType((int)5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'a/b/c/'", "'/'", "4")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "','", "1")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u4fe1\u5ff5");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "','", "2")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u7231");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "','", "3")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'\u4fe1\u5ff5,\u7231,\u5e0c\u671b'", "','", "4")))).isNull((Type)VarcharType.createVarcharType((int)7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'\u8b49\u8bc1\u8a3c'", "'\u8bc1'", "1")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("\u8b49");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'\u8b49\u8bc1\u8a3c'", "'\u8bc1'", "2")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("\u8a3c");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("split_part", "'\u8b49\u8bc1\u8a3c'", "'\u8bc1'", "3")))).isNull((Type)VarcharType.createVarcharType((int)3));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_part", "'abc'", "''", "0")::evaluate).hasMessage("Index must be greater than zero");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_part", "'abc'", "''", "-1")::evaluate).hasMessage("Index must be greater than zero");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_part", "utf8(from_hex('CE'))", "''", "1")::evaluate).hasMessage("Invalid UTF-8 encoding");
    }

    @Test
    public void testSplitPartInvalid() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("split_part", "'abc-@-def-@-ghi'", "'-@-'", "0")::evaluate).hasMessage("Index must be greater than zero");
    }

    @Test
    public void testLeftTrim() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'   '")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello  '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'hello  '")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "' hello world '")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("hello world ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "' \u4fe1\u5ff5 \u7231 \u5e0c\u671b '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  \u4fe1\u5ff5 \u7231 \u5e0c\u671b'")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
    }

    @Test
    public void testCharLeftTrim() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('' AS CHAR(20))")))).hasType((Type)VarcharType.createVarcharType((int)20)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  hello  ' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  hello' AS CHAR(7))")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('hello  ' AS CHAR(7))")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST(' hello world ' AS CHAR(13))")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(10))")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
    }

    @Test
    public void testRightTrim() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'   '")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'  hello  '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'  hello'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'hello  '")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "' hello world '")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 '")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "' \u4fe1\u5ff5 \u7231 \u5e0c\u671b '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo(" \u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'  \u4fe1\u5ff5 \u7231 \u5e0c\u671b'")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  \u4fe1\u5ff5 \u7231 \u5e0c\u671b");
    }

    @Test
    public void testCharRightTrim() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('' AS CHAR(20))")))).hasType((Type)VarcharType.createVarcharType((int)20)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  hello  ' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  hello' AS CHAR(7))")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('hello  ' AS CHAR(7))")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST(' hello world ' AS CHAR(13))")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ' AS CHAR(10))")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo(" \u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9))")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  \u4fe1\u5ff5 \u7231 \u5e0c\u671b");
    }

    @Test
    public void testLeftTrimParametrized() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "''", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'   '", "''")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("   ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello  '", "''")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello  '", "' '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello  '", "CHAR ' '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello  '", "'he '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("llo  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello'", "' '")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'  hello'", "'e h'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("llo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'hello  '", "'l'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "' hello world '", "' '")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("hello world ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "' hello world '", "' eh'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("llo world ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "' hello world '", "' ehlowrd'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "' hello world '", "' x'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("hello world ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "'\u017a\u00f3\u0142\u0107'", "'\u00f3\u017a'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("\u0142\u0107");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(LTRIM(utf8(from_hex('81')), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(129));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(LTRIM(CONCAT(utf8(from_hex('81')), ' '), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(129, 32));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(LTRIM(CONCAT(' ', utf8(from_hex('81'))), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(129));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(LTRIM(CONCAT(' ', utf8(from_hex('81')), ' '), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(129, 32));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("ltrim", "'hello world'", "utf8(from_hex('81'))")::evaluate).hasMessage("Invalid UTF-8 encoding in characters: \ufffd");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("ltrim", "'hello wolrd'", "utf8(from_hex('3281'))")::evaluate).hasMessage("Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    @Test
    public void testCharLeftTrimParametrized() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('' AS CHAR(1))", "''")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('   ' AS CHAR(3))", "''")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  hello  ' AS CHAR(9))", "''")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  hello  ' AS CHAR(9))", "' '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  hello  ' AS CHAR(9))", "'he '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("llo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  hello' AS CHAR(7))", "' '")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('  hello' AS CHAR(7))", "'e h'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("llo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('hello  ' AS CHAR(7))", "'l'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST(' hello world ' AS CHAR(13))", "' '")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST(' hello world ' AS CHAR(13))", "' eh'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("llo world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST(' hello world ' AS CHAR(13))", "' ehlowrd'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST(' hello world ' AS CHAR(13))", "' x'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("ltrim", "CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4))", "'\u00f3\u017a'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("\u0142\u0107");
    }

    private static SqlVarbinary varbinary(int ... bytesAsInts) {
        byte[] bytes = new byte[bytesAsInts.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)bytesAsInts[i];
        }
        return new SqlVarbinary(bytes);
    }

    @Test
    public void testRightTrimParametrized() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "''", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'   '", "''")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("   ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'  hello  '", "''")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'  hello  '", "' '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'  hello  '", "'lo '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  he");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'hello  '", "' '")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'hello  '", "'l o'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("he");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'hello  '", "'l'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "' hello world '", "' '")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "' hello world '", "' ld'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello wor");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "' hello world '", "' ehlowrd'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "' hello world '", "' x'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('abc def' AS CHAR(7))", "'def'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "'\u017a\u00f3\u0142\u0107'", "'\u0107\u0142'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("\u017a\u00f3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(RTRIM(utf8(from_hex('81')), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(129));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(RTRIM(CONCAT(utf8(from_hex('81')), ' '), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(129));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(RTRIM(CONCAT(' ', utf8(from_hex('81'))), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(32, 129));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(RTRIM(CONCAT(' ', utf8(from_hex('81')), ' '), ' ') AS VARBINARY)")))).isEqualTo(TestStringFunctions.varbinary(32, 129));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rtrim", "'hello world'", "utf8(from_hex('81'))")::evaluate).hasMessage("Invalid UTF-8 encoding in characters: \ufffd");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rtrim", "'hello world'", "utf8(from_hex('3281'))")::evaluate).hasMessage("Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    @Test
    public void testCharRightTrimParametrized() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('' AS CHAR(1))", "''")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('   ' AS CHAR(3))", "''")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  hello  ' AS CHAR(9))", "''")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  hello  ' AS CHAR(9))", "' '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  hello  ' AS CHAR(9))", "'he '")))).hasType((Type)VarcharType.createVarcharType((int)9)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  hello' AS CHAR(7))", "' '")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('  hello' AS CHAR(7))", "'e h'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("  hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('hello  ' AS CHAR(7))", "'l'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST(' hello world ' AS CHAR(13))", "' '")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST(' hello world ' AS CHAR(13))", "' eh'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST(' hello world ' AS CHAR(13))", "' ehlowrd'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST(' hello world ' AS CHAR(13))", "' x'")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo(" hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rtrim", "CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4))", "'\u0107\u0142'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("\u017a\u00f3");
    }

    @Test
    public void testVarcharToVarcharX() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "VARCHAR 'HELLO'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("hello");
    }

    @Test
    public void testLower() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "'Hello World'")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("hello world");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "'WHAT!!'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("what!!");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "'\u00d6STERREICH'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo(TestStringFunctions.lowerByCodePoint("\u00d6sterreich"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "'From\ud801\udc2dTo'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo(TestStringFunctions.lowerByCodePoint("from\ud801\udc2dto"));
    }

    @Test
    public void testCharLower() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "CAST('' AS CHAR(10))")))).hasType((Type)CharType.createCharType((int)10)).isEqualTo(TestStringFunctions.padRight("", 10));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "CAST('Hello World' AS CHAR(11))")))).hasType((Type)CharType.createCharType((int)11)).isEqualTo(TestStringFunctions.padRight("hello world", 11));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "CAST('WHAT!!' AS CHAR(6))")))).hasType((Type)CharType.createCharType((int)6)).isEqualTo(TestStringFunctions.padRight("what!!", 6));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "CAST('\u00d6STERREICH' AS CHAR(10))")))).hasType((Type)CharType.createCharType((int)10)).isEqualTo(TestStringFunctions.padRight(TestStringFunctions.lowerByCodePoint("\u00d6sterreich"), 10));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lower", "CAST('From\ud801\udc2dTo' AS CHAR(7))")))).hasType((Type)CharType.createCharType((int)7)).isEqualTo(TestStringFunctions.padRight(TestStringFunctions.lowerByCodePoint("from\ud801\udc2dto"), 7));
    }

    @Test
    public void testUpper() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "''")))).hasType((Type)VarcharType.createVarcharType((int)0)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "'Hello World'")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("HELLO WORLD");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "'what!!'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("WHAT!!");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "'\u00d6sterreich'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo(TestStringFunctions.upperByCodePoint("\u00d6") + "STERREICH");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "'From\ud801\udc2dTo'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("FROM" + TestStringFunctions.upperByCodePoint("\ud801\udc2d") + "TO");
    }

    @Test
    public void testCharUpper() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "CAST('' AS CHAR(10))")))).hasType((Type)CharType.createCharType((int)10)).isEqualTo(TestStringFunctions.padRight("", 10));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "CAST('Hello World' AS CHAR(11))")))).hasType((Type)CharType.createCharType((int)11)).isEqualTo(TestStringFunctions.padRight("HELLO WORLD", 11));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "CAST('what!!' AS CHAR(6))")))).hasType((Type)CharType.createCharType((int)6)).isEqualTo(TestStringFunctions.padRight("WHAT!!", 6));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "CAST('\u00d6sterreich' AS CHAR(10))")))).hasType((Type)CharType.createCharType((int)10)).isEqualTo(TestStringFunctions.padRight(TestStringFunctions.upperByCodePoint("\u00d6") + "STERREICH", 10));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("upper", "CAST('From\ud801\udc2dTo' AS CHAR(7))")))).hasType((Type)CharType.createCharType((int)7)).isEqualTo(TestStringFunctions.padRight("FROM" + TestStringFunctions.upperByCodePoint("\ud801\udc2d") + "TO", 7));
    }

    @Test
    public void testLeftPad() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'text'", "5", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("xtext");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'text'", "4", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("text");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'text'", "6", "'xy'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("xytext");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'text'", "7", "'xy'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("xyxtext");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'text'", "9", "'xyz'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("xyzxytext");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "10", "'\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u671b\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "11", "'\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u671b\u671b\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "12", "'\u5e0c\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u5e0c\u671b\u5e0c\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "13", "'\u5e0c\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u5e0c\u671b\u5e0c\u671b\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "''", "3", "'a'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("aaa");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'abc'", "0", "'e'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'text'", "3", "'xy'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("tex");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "5", "'\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u4fe1\u5ff5 \u7231 ");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("lpad", "'abc'", "3", "''")::evaluate).hasMessage("Padding string must not be empty");
        long maxSize = Integer.MAX_VALUE;
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("lpad", "'abc'", "-1", "'foo'")::evaluate).hasMessage("Target length must be in the range [0.." + maxSize + "]");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("lpad", "'abc'", Long.toString(maxSize + 1L), "''")::evaluate).hasMessage("Target length must be in the range [0.." + maxSize + "]");
    }

    @Test
    public void testRightPad() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'text'", "5", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("textx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'text'", "4", "'x'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("text");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'text'", "6", "'xy'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("textxy");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'text'", "7", "'xy'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("textxyx");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'text'", "9", "'xyz'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("textxyzxy");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "10", "'\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "11", "'\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u671b\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "12", "'\u5e0c\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u5e0c\u671b\u5e0c");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "13", "'\u5e0c\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u5e0c\u671b\u5e0c\u671b");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "''", "3", "'a'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("aaa");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'abc'", "0", "'e'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'text'", "3", "'xy'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("tex");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "'\u4fe1\u5ff5 \u7231 \u5e0c\u671b  '", "5", "'\u671b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u4fe1\u5ff5 \u7231 ");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rpad", "'abc'", "3", "''")::evaluate).hasMessage("Padding string must not be empty");
        long maxSize = Integer.MAX_VALUE;
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rpad", "'abc'", "-1", "'foo'")::evaluate).hasMessage("Target length must be in the range [0.." + maxSize + "]");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rpad", "'abc'", Long.toString(maxSize + 1L), "''")::evaluate).hasMessage("Target length must be in the range [0.." + maxSize + "]");
    }

    @Test
    public void testNormalize() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("normalize(value, NFD)").binding("value", "'sch\u00f6n'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("scho\u0308n");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("normalize('sch\u00f6n')")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("sch\u00f6n");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("normalize(value, NFC)").binding("value", "'sch\u00f6n'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("sch\u00f6n");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("normalize(value, NFKD)").binding("value", "'sch\u00f6n'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("scho\u0308n");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("normalize(value, NFKC)").binding("value", "'sch\u00f6n'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("sch\u00f6n");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("normalize(value, NFKC)").binding("value", "'\u3231\u3327\u3326\u2162'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("(\u682a)\u30c8\u30f3\u30c9\u30ebIII");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("normalize(value, NFKC)").binding("value", "'\uff8a\uff9d\uff76\uff78\uff76\uff85'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\u30cf\u30f3\u30ab\u30af\u30ab\u30ca");
    }

    @Test
    public void testFromLiteralParameter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("vl", "cast('aaa' as varchar(3))")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("vl", "cast('aaa' as varchar(7))")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("vl", "'aaaa'")))).isEqualTo(4L);
    }

    private static String lowerByCodePoint(String string) {
        int[] upperCodePoints = string.codePoints().map(Character::toLowerCase).toArray();
        return new String(upperCodePoints, 0, upperCodePoints.length);
    }

    private static String upperByCodePoint(String string) {
        int[] upperCodePoints = string.codePoints().map(Character::toUpperCase).toArray();
        return new String(upperCodePoints, 0, upperCodePoints.length);
    }

    @Test
    public void testFromUtf8() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_utf8", "to_utf8('hello')")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("hello");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_utf8", "from_hex('58BF')")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("X\ufffd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_utf8", "from_hex('58DF')")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("X\ufffd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_utf8", "from_hex('58F7')")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("X\ufffd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_utf8", "from_hex('58BF')", "'#'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("X#");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_utf8", "from_hex('58DF')", "35")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("X#");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_utf8", "from_hex('58BF')", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("X");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_utf8", "to_utf8('hello')", "'foo'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_utf8", "to_utf8('hello')", "1114112")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testCharConcat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'ab '", "cast(' ' as char(1))")))).hasType((Type)CharType.createCharType((int)4)).isEqualTo("ab  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'ab '", "cast(' ' as char(1))")))).hasType((Type)CharType.createCharType((int)4)).isEqualTo("ab  ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'ab '", "cast('a' as char(2))")))).hasType((Type)CharType.createCharType((int)5)).isEqualTo("ab a ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'ab '", "cast('a' as char(2))")))).hasType((Type)CharType.createCharType((int)5)).isEqualTo("ab a ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'ab '", "cast('' as char(0))")))).hasType((Type)CharType.createCharType((int)3)).isEqualTo("ab ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'ab '", "cast('' as char(0))")))).hasType((Type)CharType.createCharType((int)3)).isEqualTo("ab ");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "'hello na\u00efve'", "cast(' world' as char(6))")))).hasType((Type)CharType.createCharType((int)17)).isEqualTo("hello na\u00efve world");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("concat", "cast('ab ' as char(40000))", "cast('' as char(40000))")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_NOT_FOUND}).hasMessage("line 1:8: Unknown type: char(80000)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "cast(null as char(1))", "cast(' ' as char(1))")))).isNull((Type)CharType.createCharType((int)2));
    }

    @Test
    public void testTranslate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcd'", "''", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("abcd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcd'", "'a'", "'z'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("zbcd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcda'", "'a'", "'z'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("zbcdz");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168'", "'\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168'", "'aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'Goi\u00e2nia'", "'\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168'", "'aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Goiania");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'S\u00e3o Paulo'", "'\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168'", "'aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Sao Paulo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'Palho\u00e7a'", "'\u00e7'", "'c'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Palhoca");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'V\u00e1rzea Paulista'", "'\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168'", "'aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Varzea Paulista");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'\ud840\udc00bcd'", "'\ud840\udc00'", "'z'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("zbcd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'\ud840\udc00bcd\ud840\udc00'", "'\ud840\udc00'", "'z'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("zbcdz");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcd'", "'b'", "'\ud840\udc00'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("a\ud840\udc00cd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcd'", "'a'", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("bcd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcd'", "'a'", "'zy'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("zbcd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcd'", "'ac'", "'z'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("zbd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("translate", "'abcd'", "'aac'", "'zq'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("zbd");
    }

    @Test
    public void testSoundex() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'jim'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("J500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'jIM'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("J500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'JIM'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("J500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'Jim'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("J500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'John'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("J500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'johannes'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("J520");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'Sarah'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("S600");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "null")))).isNull((Type)VarcharType.createVarcharType((int)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "''")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'123'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'\ud83d\ude80'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'j~im'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("J500");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("soundex", "'j\u0105mes'")::evaluate).hasMessage("The character is not mapped: \u0104 (index=195)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("soundex", "'x123'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("X000");
    }
}

