/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.SqlFunction;
import io.trino.operator.scalar.ApplyFunction;
import io.trino.operator.scalar.InvokeFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestLambdaExpression {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION, InvokeFunction.INVOKE_FUNCTION}));
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1)").binding("a", "5")))).isEqualTo(6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1)").binding("a", "5 + RANDOM(1)")))).isEqualTo(6);
    }

    @Test
    public void testParameterName() {
        String nonLetters = "a.b c; d ' \n \\n \"";
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, " + TestLambdaExpression.quote(nonLetters) + " -> " + TestLambdaExpression.quote(nonLetters) + " * 2)").binding("a", "5")))).isEqualTo(10);
    }

    @Test
    public void testNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1)").binding("a", "3")))).isEqualTo(4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1)").binding("a", "NULL")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1)").binding("a", "CAST (NULL AS INTEGER)")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x IS NULL)").binding("a", "3")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x IS NULL)").binding("a", "NULL")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x IS NULL)").binding("a", "CAST (NULL AS INTEGER)")))).isEqualTo(true);
    }

    @Test
    public void testUnreferencedLambdaArgument() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> 6)").binding("a", "5")))).isEqualTo(6);
    }

    @Test
    public void testLambdaWithoutArgument() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("invoke(() -> 42)")))).isEqualTo(42);
    }

    @Test
    public void testSessionDependent() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Kiritimati")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x || current_timezone())", session).binding("a", "'timezone: '")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("timezone: Pacific/Kiritimati");
    }

    @Test
    public void testInstanceFunction() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> concat(ARRAY [1], x))").binding("a", "ARRAY[2]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
    }

    @Test
    public void testNestedLambda() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> apply(x + 7, y -> apply(y * 3, z -> z * 5) + 1) * 2)").binding("a", "11")))).isEqualTo(542);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> apply(x + 7, x -> apply(x * 3, x -> x * 5) + 1) * 2)").binding("a", "11")))).isEqualTo(542);
    }

    @Test
    public void testRowAccess() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(CAST(a AS ROW(x INTEGER, y VARCHAR)), r -> r[1])").binding("a", "ROW(1, 'a')")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, r -> r[2])").binding("a", "CAST(ROW(1, 'a') AS ROW(x INTEGER, y VARCHAR))")))).isEqualTo("a");
    }

    @Test
    public void testBind() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, \"$internal$bind\"(b, (x, y) -> x + y))").binding("a", "90").binding("b", "9")))).isEqualTo(99);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("invoke(\"$internal$bind\"(a, x -> x + 1))").binding("a", "8")))).isEqualTo(9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, \"$internal$bind\"(b, c, (x, y, z) -> x + y + z))").binding("a", "900").binding("b", "90").binding("c", "9")))).isEqualTo(999);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("invoke(\"$internal$bind\"(a, b, (x, y) -> x + y))").binding("a", "90").binding("b", "9")))).isEqualTo(99);
    }

    @Test
    public void testCoercion() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 9.0E0)").binding("a", "90")))).isEqualTo(99.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, \"$internal$bind\"(b, (x, y) -> x + y))").binding("a", "90").binding("b", "9.0E0")))).isEqualTo(99.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("invoke(\"$internal$bind\"(a, x -> x + 1.0E0))").binding("a", "8")))).isEqualTo(9.0);
    }

    @Test
    public void testTypeCombinations() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1)").binding("a", "25")))).isEqualTo(26);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1.0E0)").binding("a", "25")))).isEqualTo(26.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x = 25)").binding("a", "25")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> to_base(x, 16))").binding("a", "25")))).hasType((Type)VarcharType.createVarcharType((int)64)).isEqualTo("19");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> ARRAY[x + 1])").binding("a", "25")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)26));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> CAST(x AS BIGINT))").binding("a", "25.6E0")))).isEqualTo(26L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x + 1.0E0)").binding("a", "25.6E0")))).isEqualTo(26.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x = 25.6E0)").binding("a", "25.6E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> CAST(x AS VARCHAR))").binding("a", "25.6E0")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("2.56E1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> MAP(ARRAY[x + 1], ARRAY[true]))").binding("a", "25.6E0")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)26.6, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> if(x, 25, 26))").binding("a", "true")))).isEqualTo(25);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> if(x, 25.6E0, 28.9E0))").binding("a", "false")))).isEqualTo(28.9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> not x)").binding("a", "true")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> CAST(x AS VARCHAR))").binding("a", "false")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("false");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> ARRAY[x])").binding("a", "true")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> from_base(x, 16))").binding("a", "'41'")))).isEqualTo(65L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> CAST(x AS DOUBLE))").binding("a", "'25.6E0'")))).isEqualTo(25.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> 'abc' = x)").binding("a", "'abc'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x || x)").binding("a", "'abc'")))).hasType((Type)VarcharType.createUnboundedVarcharType()).isEqualTo("abcabc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> ROW(x, CAST(x AS INTEGER), x > '0'))").binding("a", "'123'")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN))).isEqualTo(ImmutableList.of((Object)"123", (Object)123, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> from_base(x[3], 10))").binding("a", "ARRAY['abc', NULL, '123']")))).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> CAST(x[3] AS DOUBLE))").binding("a", "ARRAY['abc', NULL, '123']")))).isEqualTo(123.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x[2] IS NULL)").binding("a", "ARRAY['abc', NULL, '123']")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> x[2])").binding("a", "ARRAY['abc', NULL, '123']")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("apply(a, x -> map_keys(x))").binding("a", "MAP(ARRAY['abc', 'def'], ARRAY[123, 456])")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableList.of((Object)"abc", (Object)"def"));
    }

    @Test
    public void testFunctionParameter() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("count(x -> x)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:12: Unexpected parameters (<function>) for function count. Expected: count(), count(t) T");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("max(x -> x)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:12: Unexpected parameters (<function>) for function max. Expected: max(t) T:orderable, max(e, bigint) E:orderable");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("sqrt(x -> x)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:12: Unexpected parameters (<function>) for function sqrt. Expected: sqrt(double)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("sqrt(x -> x, 123, x -> x)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:12: Unexpected parameters (<function>, integer, <function>) for function sqrt. Expected: sqrt(double)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("pow(x -> x, 123)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:12: Unexpected parameters (<function>, integer) for function pow. Expected: pow(double, double)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("pow(123, x -> x)")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:12: Unexpected parameters (integer, <function>) for function pow. Expected: pow(double, double)");
    }

    private static String quote(String identifier) {
        return "\"" + identifier.replace("\"", "\"\"") + "\"";
    }
}

