/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.json.JsonCodec;
import io.trino.client.FailureInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.Failures;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestFailureFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testFailure() {
        String failure = JsonCodec.jsonCodec(FailureInfo.class).toJson((Object)Failures.toFailure((Throwable)new RuntimeException("fail me")).toFailureInfo());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("fail", "json_parse('" + failure + "')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("fail me");
    }
}

