/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.TrinoException;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestConditions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLike() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like 'X_monkeyX_' escape 'X'").binding("a", "'_monkey_'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like 'monkey'").binding("a", "'monkey'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like 'mon%'").binding("a", "'monkey'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like '%key'").binding("a", "'monkey'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like 'm____y'").binding("a", "'monkey'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like 'lion'").binding("a", "'monkey'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like 'monkey'").binding("a", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like null").binding("a", "'monkey'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a like 'monkey' escape null").binding("a", "'monkey'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like 'X_monkeyX_' escape 'X'").binding("a", "'_monkey_'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like 'monkey'").binding("a", "'monkey'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like 'mon%'").binding("a", "'monkey'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like '%key'").binding("a", "'monkey'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like 'm____y'").binding("a", "'monkey'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like 'lion'").binding("a", "'monkey'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like 'monkey'").binding("a", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like null").binding("a", "'monkey'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a not like 'monkey' escape null").binding("a", "'monkey'")))).isNull((Type)BooleanType.BOOLEAN);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.expression("a like 'monkey' escape 'foo'").binding("a", "'monkey'").evaluate()).isInstanceOf(TrinoException.class)).hasMessage("Escape string must be a single character");
    }

    @Test
    public void testDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "null").binding("b", "null")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "null").binding("b", "1")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "1").binding("b", "null")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "1").binding("b", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "1").binding("b", "2")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT DISTINCT FROM b").binding("a", "null").binding("b", "null")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT DISTINCT FROM b").binding("a", "null").binding("b", "1")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT DISTINCT FROM b").binding("a", "1").binding("b", "null")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT DISTINCT FROM b").binding("a", "1").binding("b", "1")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT DISTINCT FROM b").binding("a", "1").binding("b", "2")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "2").binding("high", "4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "3").binding("high", "3")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "2").binding("high", "3")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "3").binding("high", "4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "4").binding("high", "2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "2").binding("low", "3").binding("high", "4")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "5").binding("low", "3").binding("high", "4")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "null").binding("low", "3").binding("high", "4")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "null").binding("high", "4")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "2").binding("high", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "3").binding("low", "3").binding("high", "4000000000")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "5").binding("low", "3").binding("high", "4000000000")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "5").binding("low", "BIGINT '3'").binding("high", "4")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "BIGINT '3'").binding("low", "3").binding("high", "4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'c'").binding("low", "'b'").binding("high", "'b'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'c'").binding("low", "'c'").binding("high", "'c'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'c'").binding("low", "'b'").binding("high", "'c'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'c'").binding("low", "'c'").binding("high", "'d'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'c'").binding("low", "'d'").binding("high", "'b'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'b'").binding("low", "'c'").binding("high", "'d'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'e'").binding("low", "'c'").binding("high", "'d'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "null").binding("low", "'b'").binding("high", "'d'")))).matches("CAST(null AS boolean)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'c'").binding("low", "null").binding("high", "'d'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value between low and high").binding("value", "'c'").binding("low", "'b'").binding("high", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "2").binding("high", "4")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "3").binding("high", "3")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "2").binding("high", "3")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "3").binding("high", "4")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "4").binding("high", "2")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "2").binding("low", "3").binding("high", "4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "5").binding("low", "3").binding("high", "4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "null").binding("low", "3").binding("high", "4")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "null").binding("high", "4")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "2").binding("high", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "3").binding("low", "3").binding("high", "4000000000")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "5").binding("low", "3").binding("high", "4000000000")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "5").binding("low", "BIGINT '3'").binding("high", "4")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "BIGINT '3'").binding("low", "3").binding("high", "4")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'c'").binding("low", "'b'").binding("high", "'b'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'c'").binding("low", "'c'").binding("high", "'c'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'c'").binding("low", "'b'").binding("high", "'c'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'c'").binding("low", "'c'").binding("high", "'d'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'c'").binding("low", "'d'").binding("high", "'b'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'b'").binding("low", "'c'").binding("high", "'d'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'e'").binding("low", "'c'").binding("high", "'d'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "null").binding("low", "'b'").binding("high", "'d'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'c'").binding("low", "null").binding("high", "'d'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not between low and high").binding("value", "'c'").binding("low", "'b'").binding("high", "null")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testIn() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in (2, 4, 3, 5)").binding("value", "3")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not in (2, 4, 3, 5)").binding("value", "3")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in (2, 4, 9, 5)").binding("value", "3")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in (2, null, 3, 5)").binding("value", "3")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in ('bar', 'baz', 'foo', 'blah')").binding("value", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in ('bar', 'baz', 'buz', 'blah')").binding("value", "'foo'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in ('bar', null, 'foo', 'blah')").binding("value", "'foo'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in (2, null, 3, 5)").binding("value", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value in (2, null)").binding("value", "3")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not in (2, null, 3, 5)").binding("value", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value not in (2, null)").binding("value", "3")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testSearchCase() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when value then 33\nend\n").binding("value", "true")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when value then BIGINT '33'\nend\n").binding("value", "true")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when value then 1\n    else 33\nend\n").binding("value", "false")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when value then 10000000000\n    else 33\nend\n").binding("value", "false")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 1\n    when condition2 then 1\n    when condition3 then 33\n    else 1\nend\n").binding("condition1", "false").binding("condition2", "false").binding("condition3", "true")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then BIGINT '1'\n    when condition2 then 1\n    when condition3 then 33\n    else 1\nend\n").binding("condition1", "false").binding("condition2", "false").binding("condition3", "true")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 10000000000\n    when condition2 then 1\n    when condition3 then 33\n    else 1\nend\n").binding("condition1", "false").binding("condition2", "false").binding("condition3", "true")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when value then 1\nend\n").binding("value", "false")))).matches("CAST(null AS integer)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when value then null\n    else 'foo'\nend\n").binding("value", "true")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 1\n    when condition2 then 33\nend\n").binding("condition1", "null").binding("condition2", "true")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 10000000000\n    when condition2 then 33\nend\n").binding("condition1", "null").binding("condition2", "true")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 1.0E0\n    when condition2 then 33\nend\n").binding("condition1", "false").binding("condition2", "true")))).matches("33E0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 2.2\n    when condition2 then 2.2\nend\n").binding("condition1", "false").binding("condition2", "true")))).hasType((Type)DecimalType.createDecimalType((int)2, (int)1)).matches("2.2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 1234567890.0987654321\n    when condition2 then 3.3\nend\n").binding("condition1", "false").binding("condition2", "true")))).matches("CAST(3.3 AS decimal(20, 10))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 1\n    when condition2 then 2.2\nend\n").binding("condition1", "false").binding("condition2", "true")))).matches("CAST(2.2 AS decimal(11, 1))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case\n    when condition1 then 1.1\n    when condition2 then 33E0\nend\n").binding("condition1", "false").binding("condition2", "true")))).matches("33E0");
    }

    @Test
    public void testSimpleCase() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then CAST(null AS varchar)\n    else 'foo'\nend\n").binding("value", "true").binding("condition", "true")))).matches("CAST(null AS varchar)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then 33\nend\n").binding("value", "true").binding("condition", "true")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then BIGINT '33'\nend\n").binding("value", "true").binding("condition", "true")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then 1\n    else 33\nend\n").binding("value", "true").binding("condition", "false")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then 10000000000\n    else 33\nend\n").binding("value", "true").binding("condition", "false")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1\n    when condition2 then 1\n    when condition3 then 33\n    else 1\nend\n").binding("value", "true").binding("condition1", "false").binding("condition2", "false").binding("condition3", "true")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then 1\nend\n").binding("value", "true").binding("condition", "false")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then null\n    else 'foo'\nend\n").binding("value", "true").binding("condition", "true")))).isNull((Type)VarcharType.createVarcharType((int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 10000000000\n    when condition2 then 33\nend\n").binding("value", "true").binding("condition1", "null").binding("condition2", "true")))).matches("BIGINT '33'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1\n    when condition2 then 33\nend\n").binding("value", "true").binding("condition1", "null").binding("condition2", "true")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition then 1\n    else 33\nend\n").binding("value", "null").binding("condition", "true")))).matches("33");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1E0\n    when condition2 then 33\nend\n").binding("value", "true").binding("condition1", "false").binding("condition2", "true")))).matches("33E0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 2.2\n    when condition2 then 2.2\nend\n").binding("value", "true").binding("condition1", "false").binding("condition2", "true")))).matches("2.2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1234567890.0987654321\n    when condition2 then 3.3\nend\n").binding("value", "true").binding("condition1", "false").binding("condition2", "true")))).matches("CAST(3.3 AS decimal(20, 10))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1\n    when condition2 then 2.2\nend\n").binding("value", "true").binding("condition1", "false").binding("condition2", "true")))).matches("CAST(2.2 AS decimal(11, 1))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1.1\n    when condition2 then 33E0\nend\n").binding("value", "true").binding("condition1", "false").binding("condition2", "true")))).matches("33E0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then result1\n    when condition2 then result2\nend\n").binding("value", "true").binding("condition1", "false").binding("result1", "1.1").binding("condition2", "true").binding("result2", "33.0E0")))).matches("33.0E0");
    }

    @Test
    public void testSimpleCaseWithCoercions() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1\n    when condition2 then 2\nend\n").binding("value", "8").binding("condition1", "double '76.1'").binding("condition2", "real '8.1'")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case value\n    when condition1 then 1\n    when condition2 then 2\nend\n").binding("value", "8").binding("condition1", "9").binding("condition2", "cast(NULL as decimal)")))).isNull((Type)IntegerType.INTEGER);
    }
}

