/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestConcatWsFunction {
    private static final int MAX_INPUT_VALUES = 254;
    private static final int MAX_CONCAT_VALUES = 253;
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSimple() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "'abc'", "'def'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "'def'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "'def'", "'pqr'", "'mno'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def,pqr,mno");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "'abc'", "'def'", "'pqr'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("defabcpqr");
    }

    @Test
    public void testEmpty() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "''", "'def'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "''", "'def'", "'pqr'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("defpqr");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "''", "''", "'pqr'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("pqr");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "''", "'def'", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "''", "''", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "'def'", "''")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def,");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "'def'", "''", "'pqr'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def,,pqr");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "''", "'pqr'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(",pqr");
    }

    @Test
    public void testNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "NULL", "'def'")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "NULL", "cast(NULL as VARCHAR)")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "NULL", "'def'", "'pqr'")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "cast(NULL as VARCHAR)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "NULL", "'pqr'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("pqr");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "'def'", "NULL")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "'def'", "NULL", "'pqr'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def,pqr");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "'def'", "NULL", "NULL", "'mno'", "'xyz'", "NULL", "'box'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("def,mno,xyz,box");
    }

    @Test
    public void testArray() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "ARRAY[]")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "ARRAY['abc']")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("abc");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "ARRAY['abc', 'def', 'pqr', 'xyz']")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("abc,def,pqr,xyz");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "null", "ARRAY['abc']")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "cast(NULL as array(varchar))")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "ARRAY['abc', null, null, 'xyz']")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("abc,xyz");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "ARRAY['abc', '', '', 'xyz','abcdefghi']")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("abc,,,xyz,abcdefghi");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 253; ++i) {
            builder.append(i).append(',');
        }
        builder.append(253);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat_ws", "','", "transform(sequence(0, 253), x -> cast(x as varchar))")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(builder.toString());
    }

    @Test
    public void testBadArray() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("concat_ws", "','", "ARRAY[1, 15]")::evaluate).hasMessageContaining("Unexpected parameters");
    }

    @Test
    public void testBadArguments() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("concat_ws", "','", "1", "15")::evaluate).hasMessageContaining("Unexpected parameters");
    }

    @Test
    public void testTooManyArguments() {
        int argumentsLimit = 127;
        String[] inputValues = new String[argumentsLimit + 1];
        inputValues[0] = "','";
        for (int i = 1; i <= argumentsLimit; ++i) {
            inputValues[i] = "'" + i + "'";
        }
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("concat_ws", inputValues)::evaluate).hasMessage("line 1:8: Too many arguments for function call concat_ws()");
    }

    @Test
    public void testLowArguments() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("concat_ws", "','")::evaluate).hasMessage("There must be two or more arguments");
    }
}

