/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.block.BlockAssertions;
import io.trino.operator.scalar.BlockSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.BlockTypeOperators;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockSet {
    private static final BlockTypeOperators BLOCK_TYPE_OPERATORS = new BlockTypeOperators(new TypeOperators());
    private static final String FUNCTION_NAME = "typed_set_test";

    @Test
    public void testConstructor() {
        int i = -2;
        while (i <= -1) {
            int expectedSize = i++;
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBlockSet.createBlockSet((Type)BigintType.BIGINT, expectedSize)).isInstanceOf(IllegalArgumentException.class)).hasMessage("maximumSize must not be negative");
        }
        Assertions.assertThatThrownBy(() -> new BlockSet(null, null, null, 1)).isInstanceOfAny(new Class[]{NullPointerException.class, IllegalArgumentException.class});
    }

    @Test
    public void testGetElementPosition() {
        int elementCount = 100;
        BlockSet blockSet = TestBlockSet.createBlockSet((Type)BigintType.BIGINT, elementCount);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            blockSet.add((Block)blockBuilder, i);
        }
        Assert.assertEquals((int)blockSet.size(), (int)elementCount);
        for (int j = 0; j < blockBuilder.getPositionCount(); ++j) {
            Assert.assertEquals((int)blockSet.positionOf((Block)blockBuilder, j), (int)j);
        }
    }

    @Test
    public void testGetElementPositionWithNull() {
        int elementCount = 100;
        BlockSet blockSet = TestBlockSet.createBlockSet((Type)BigintType.BIGINT, elementCount);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            if (i % 10 == 0) {
                blockBuilder.appendNull();
            } else {
                BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            }
            blockSet.add((Block)blockBuilder, i);
        }
        Assert.assertEquals((int)blockSet.size(), (int)(elementCount - elementCount / 10 + 1));
        int nullCount = 0;
        for (int j = 0; j < blockBuilder.getPositionCount(); ++j) {
            if (!blockBuilder.isNull(j)) {
                Assert.assertEquals((int)blockSet.positionOf((Block)blockBuilder, j), (int)(j - nullCount + 1));
                continue;
            }
            Assert.assertEquals((int)blockSet.positionOf((Block)blockBuilder, j), (int)0);
            ++nullCount;
        }
    }

    @Test
    public void testMaxSize() {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)0, (Object)1, (Object)10, (Object)100, (Object)1000).iterator();
        while (unmodifiableIterator.hasNext()) {
            int i;
            int maxSize = (Integer)unmodifiableIterator.next();
            BlockSet blockSet = TestBlockSet.createBlockSet((Type)BigintType.BIGINT, maxSize);
            for (i = 0; i < maxSize; ++i) {
                Assertions.assertThat((boolean)blockSet.add(TestBlockSet.toBlock(i == 20 ? null : Long.valueOf(i)), 0)).isTrue();
                Assertions.assertThat((int)blockSet.size()).isEqualTo(i + 1);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> blockSet.add(TestBlockSet.toBlock(Long.valueOf(maxSize)), 0)).isInstanceOf(IllegalStateException.class)).hasMessage("BlockSet is full");
            Assertions.assertThat((int)blockSet.size()).isEqualTo(maxSize);
            if (maxSize < 20) {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> blockSet.add(TestBlockSet.toBlock(null), 0)).isInstanceOf(IllegalStateException.class)).hasMessage("BlockSet is full");
                Assertions.assertThat((int)blockSet.size()).isEqualTo(maxSize);
            }
            for (i = 0; i < maxSize; ++i) {
                Assertions.assertThat((boolean)blockSet.add(TestBlockSet.toBlock(i == 20 ? null : Long.valueOf(i)), 0)).isFalse();
            }
        }
    }

    private static Block toBlock(Long value) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(1);
        if (value == null) {
            blockBuilder.appendNull();
        } else {
            BigintType.BIGINT.writeLong(blockBuilder, value.longValue());
        }
        return blockBuilder.build();
    }

    @Test
    public void testGetElementPositionRandom() {
        VariableWidthBlockBuilder keys = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)keys, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice((BlockBuilder)keys, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice((BlockBuilder)keys, Slices.utf8Slice((String)"abc"));
        BlockSet set = TestBlockSet.createBlockSet((Type)VarcharType.VARCHAR, 4);
        for (int i = 0; i < keys.getPositionCount(); ++i) {
            set.add((Block)keys, i);
        }
        VariableWidthBlockBuilder values = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)values, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice((BlockBuilder)values, Slices.utf8Slice((String)"abc"));
        VarcharType.VARCHAR.writeSlice((BlockBuilder)values, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice((BlockBuilder)values, Slices.utf8Slice((String)"bad"));
        values.appendNull();
        Assert.assertEquals((int)set.positionOf((Block)values, 4), (int)-1);
        Assert.assertEquals((int)set.positionOf((Block)values, 2), (int)0);
        Assert.assertEquals((int)set.positionOf((Block)values, 1), (int)2);
        Assert.assertEquals((int)set.positionOf((Block)values, 0), (int)1);
        Assert.assertFalse((boolean)set.contains((Block)values, 3));
        set.add((Block)values, 4);
        Assert.assertTrue((boolean)set.contains((Block)values, 4));
    }

    @Test
    public void testBigintSimpleBlockSet() {
        TestBlockSet.testBigint(BlockAssertions.createEmptyLongsBlock());
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(1L));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(1L, 2L, 3L));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(1L, 2L, 3L, 1L, 2L, 3L));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(1L, null, 3L));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(null, null, null));
        TestBlockSet.testBigint(BlockAssertions.createLongSequenceBlock(0, 100));
        TestBlockSet.testBigint(BlockAssertions.createLongSequenceBlock(-100, 100));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(Collections.nCopies(1, null)));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(Collections.nCopies(100, null)));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(Collections.nCopies(2000, null)));
        TestBlockSet.testBigint(BlockAssertions.createLongsBlock(Collections.nCopies(2000, 0L)));
    }

    private static void testBigint(Block longBlock) {
        BlockSet blockSet = TestBlockSet.createBlockSet((Type)BigintType.BIGINT, longBlock.getPositionCount());
        HashSet<Long> set = new HashSet<Long>();
        for (int blockPosition = 0; blockPosition < longBlock.getPositionCount(); ++blockPosition) {
            long number = BigintType.BIGINT.getLong(longBlock, blockPosition);
            Assert.assertEquals((boolean)blockSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)blockSet.size(), (int)set.size());
            set.add(number);
            blockSet.add(longBlock, blockPosition);
            Assert.assertEquals((boolean)blockSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)blockSet.size(), (int)set.size());
        }
    }

    @Test
    public void testMemoryExceeded() {
        DataSize maxSize = DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(1024);
        int i = 0;
        while (blockBuilder.getSizeInBytes() < maxSize.toBytes() + 8L) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            ++i;
        }
        Block block = blockBuilder.build();
        BlockSet blockSet = TestBlockSet.createBlockSet((Type)BigintType.BIGINT, block.getPositionCount());
        for (int i2 = 0; i2 < block.getPositionCount(); ++i2) {
            blockSet.add(block, i2);
        }
        Assertions.assertThat((int)blockSet.size()).isEqualTo(block.getPositionCount());
        BlockBuilder testOutput = BigintType.BIGINT.createFixedSizeBlockBuilder(1024);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> blockSet.getAllWithSizeLimit(testOutput, FUNCTION_NAME, maxSize)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT}).hasMessageContaining(FUNCTION_NAME);
        int actualPositionsWritten = testOutput.getPositionCount();
        Assertions.assertThat((int)actualPositionsWritten).isLessThan(block.getPositionCount());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> blockSet.getAllWithSizeLimit(testOutput, FUNCTION_NAME, maxSize)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT}).hasMessageContaining(FUNCTION_NAME);
        Assertions.assertThat((int)testOutput.getPositionCount()).isEqualTo(actualPositionsWritten * 2);
        blockSet.getAllWithSizeLimit(testOutput, FUNCTION_NAME, DataSize.of((long)30L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        Assertions.assertThat((int)testOutput.getPositionCount()).isEqualTo(actualPositionsWritten * 2 + blockSet.size());
    }

    private static BlockSet createBlockSet(Type type, int expectedSize) {
        return new BlockSet(type, BLOCK_TYPE_OPERATORS.getDistinctFromOperator(type), BLOCK_TYPE_OPERATORS.getHashCodeOperator(type), expectedSize);
    }
}

