/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestBitwiseFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBitCount() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "0", "64")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "7", "64")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "24", "64")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "-8", "64")))).isEqualTo(61L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", Long.toString(Integer.MAX_VALUE), "64")))).isEqualTo(31L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", Long.toString(Integer.MIN_VALUE), "64")))).isEqualTo(33L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", Long.toString(Long.MAX_VALUE), "64")))).isEqualTo(63L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", Long.toString(Long.MIN_VALUE), "64")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "0", "32")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "7", "32")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "24", "32")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "-8", "32")))).isEqualTo(29L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", Long.toString(Integer.MAX_VALUE), "32")))).isEqualTo(31L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", Long.toString(Integer.MIN_VALUE), "32")))).isEqualTo(1L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("bit_count", Long.toString(0x80000000L), "32")::evaluate).hasMessage("Number must be representable with the bits specified. 2147483648 cannot be represented with 32 bits");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("bit_count", Long.toString(-2147483649L), "32")::evaluate).hasMessage("Number must be representable with the bits specified. -2147483649 cannot be represented with 32 bits");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "1152921504598458367", "62")))).isEqualTo(59L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "-1", "62")))).isEqualTo(62L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "33554132", "26")))).isEqualTo(20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bit_count", "-1", "26")))).isEqualTo(26L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("bit_count", "1152921504598458367", "60")::evaluate).hasMessage("Number must be representable with the bits specified. 1152921504598458367 cannot be represented with 60 bits");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("bit_count", "33554132", "25")::evaluate).hasMessage("Number must be representable with the bits specified. 33554132 cannot be represented with 25 bits");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("bit_count", "0", "-1")::evaluate).hasMessage("Bits specified in bit_count must be between 2 and 64, got -1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("bit_count", "0", "1")::evaluate).hasMessage("Bits specified in bit_count must be between 2 and 64, got 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("bit_count", "0", "65")::evaluate).hasMessage("Bits specified in bit_count must be between 2 and 64, got 65");
    }

    @Test
    public void testBitwiseNot() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_not", "0")))).isEqualTo(-1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_not", "-1")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_not", "8")))).isEqualTo(-9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_not", "-8")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_not", Long.toString(Long.MAX_VALUE))))).isEqualTo(Long.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_not", Long.toString(Long.MIN_VALUE))))).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    public void testBitwiseAnd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_and", "0", "-1")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_and", "3", "8")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_and", "-4", "12")))).isEqualTo(12L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_and", "60", "21")))).isEqualTo(20L);
    }

    @Test
    public void testBitwiseOr() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_or", "0", "-1")))).isEqualTo(-1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_or", "3", "8")))).isEqualTo(11L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_or", "-4", "12")))).isEqualTo(-4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_or", "60", "21")))).isEqualTo(61L);
    }

    @Test
    public void testBitwiseXor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_xor", "0", "-1")))).isEqualTo(-1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_xor", "3", "8")))).isEqualTo(11L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_xor", "-4", "12")))).isEqualTo(-16L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_xor", "60", "21")))).isEqualTo(41L);
    }

    @Test
    public void testBitwiseLeftShift() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "TINYINT'7'", "2")))).isEqualTo((byte)28);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "TINYINT '-7'", "2")))).isEqualTo((byte)-28);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "TINYINT '1'", "7")))).isEqualTo((byte)-128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "TINYINT '-128'", "1")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "TINYINT '-65'", "1")))).isEqualTo((byte)126);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "TINYINT '-7'", "64")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "TINYINT '-128'", "0")))).isEqualTo((byte)-128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "SMALLINT '7'", "2")))).isEqualTo((short)28);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "SMALLINT '-7'", "2")))).isEqualTo((short)-28);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "SMALLINT '1'", "7")))).isEqualTo((short)128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "SMALLINT '-32768'", "1")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "SMALLINT '-65'", "1")))).isEqualTo((short)-130);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "SMALLINT '-7'", "64")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "SMALLINT '-32768'", "0")))).isEqualTo((short)Short.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "INTEGER '7'", "2")))).isEqualTo(28);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "INTEGER '-7'", "2")))).isEqualTo(-28);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "INTEGER '1'", "7")))).isEqualTo(128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "INTEGER '-2147483648'", "1")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "INTEGER '-65'", "1")))).isEqualTo(-130);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "INTEGER '-7'", "64")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "INTEGER '-2147483648'", "0")))).isEqualTo(Integer.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "BIGINT '7'", "2")))).isEqualTo(28L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "BIGINT '-7'", "2")))).isEqualTo(-28L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_left_shift", "BIGINT '-7'", "64")))).isEqualTo(0L);
    }

    @Test
    public void testBitwiseRightShift() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "TINYINT '7'", "2")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "TINYINT '-7'", "2")))).isEqualTo((byte)62);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "TINYINT '-7'", "64")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "TINYINT '-128'", "0")))).isEqualTo((byte)-128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "SMALLINT '7'", "2")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "SMALLINT '-7'", "2")))).isEqualTo((short)16382);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "SMALLINT '-7'", "64")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "SMALLINT '-32768'", "0")))).isEqualTo((short)Short.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "INTEGER '7'", "2")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "INTEGER '-7'", "2")))).isEqualTo(0x3FFFFFFE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "INTEGER '-7'", "64")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "INTEGER '-2147483648'", "0")))).isEqualTo(Integer.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "BIGINT '7'", "2")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "BIGINT '-7'", "2")))).isEqualTo(0x3FFFFFFFFFFFFFFEL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift", "BIGINT '-7'", "64")))).isEqualTo(0L);
    }

    @Test
    public void testBitwiseRightShiftArithmetic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "TINYINT '7'", "2")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "TINYINT '-7'", "2")))).isEqualTo((byte)-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "TINYINT '7'", "64")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "TINYINT '-7'", "64")))).isEqualTo((byte)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "TINYINT '-128'", "0")))).isEqualTo((byte)-128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "SMALLINT '7'", "2")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "SMALLINT '-7'", "2")))).isEqualTo((short)-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "SMALLINT '7'", "64")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "SMALLINT '-7'", "64")))).isEqualTo((short)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "SMALLINT '-32768'", "0")))).isEqualTo((short)Short.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "INTEGER '7'", "2")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "INTEGER '-7'", "2")))).isEqualTo(-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "INTEGER '7'", "64")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "INTEGER '-7'", "64")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "INTEGER '-2147483648'", "0")))).isEqualTo(Integer.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "BIGINT '7'", "2")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "BIGINT '-7'", "2")))).isEqualTo(-2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "BIGINT '7'", "64")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_right_shift_arithmetic", "BIGINT '-7'", "64")))).isEqualTo(-1L);
    }
}

