/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayTransformFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> 9)").binding("a", "ARRAY[5, 6]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)9, (Object)9));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1)").binding("a", "ARRAY[5, 6]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)6, (Object)7));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1)").binding("a", "ARRAY[5 + RANDOM(1), 6]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)6, (Object)7));
    }

    @Test
    public void testNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1)").binding("a", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1)").binding("a", "ARRAY[NULL, NULL]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1)").binding("a", "ARRAY[NULL, 3, NULL]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(Arrays.asList(null, 4, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x IS NULL)").binding("a", "ARRAY[3]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x IS NULL)").binding("a", "ARRAY[NULL, NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x IS NULL)").binding("a", "ARRAY[NULL, 3, NULL]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false, (Object)true));
    }

    @Test
    public void testSessionDependent() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Kiritimati")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x || current_timezone())", session).binding("a", "ARRAY['timezone: ', 'tz: ']")))).hasType((Type)new ArrayType((Type)VarcharType.VARCHAR)).isEqualTo(ImmutableList.of((Object)"timezone: Pacific/Kiritimati", (Object)"tz: Pacific/Kiritimati"));
    }

    @Test
    public void testInstanceexpression() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> concat(ARRAY[1], x))").binding("a", "ARRAY[2, 3, 4, NULL, 5]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(Arrays.asList(ImmutableList.of((Object)1, (Object)2), ImmutableList.of((Object)1, (Object)3), ImmutableList.of((Object)1, (Object)4), null, ImmutableList.of((Object)1, (Object)5)));
    }

    @Test
    public void testTypeCombinations() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1)").binding("a", "ARRAY[25, 26]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)26, (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1.0E0)").binding("a", "ARRAY[25, 26]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)26.0, (Object)27.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x = 25)").binding("a", "ARRAY[25, 26]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> to_base(x, 16))").binding("a", "ARRAY[25, 26]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)64))).isEqualTo(ImmutableList.of((Object)"19", (Object)"1a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> ARRAY[x + 1])").binding("a", "ARRAY[25, 26]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)26), (Object)ImmutableList.of((Object)27)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> CAST(x AS BIGINT))").binding("a", "ARRAY[25.6E0, 27.3E0]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)26L, (Object)27L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x + 1.0E0)").binding("a", "ARRAY[25.6E0, 27.3E0]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)26.6, (Object)28.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x = 25.6E0)").binding("a", "ARRAY[25.6E0, 27.3E0]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> CAST(x AS VARCHAR))").binding("a", "ARRAY[25.6E0, 27.3E0]")))).hasType((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())).isEqualTo(ImmutableList.of((Object)"2.56E1", (Object)"2.73E1"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> MAP(ARRAY[x + 1], ARRAY[true]))").binding("a", "ARRAY[25.6E0, 27.3E0]")))).hasType((Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN))).isEqualTo(ImmutableList.of((Object)ImmutableMap.of((Object)26.6, (Object)true), (Object)ImmutableMap.of((Object)28.3, (Object)true)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> if(x, 25, 26))").binding("a", "ARRAY[true, false]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)25, (Object)26));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> if(x, 25.6E0, 28.9E0))").binding("a", "ARRAY[false, true]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)28.9, (Object)25.6));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> not x)").binding("a", "ARRAY[true, false]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)false, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> CAST(x AS VARCHAR))").binding("a", "ARRAY[false, true]")))).hasType((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())).isEqualTo(ImmutableList.of((Object)"false", (Object)"true"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> ARRAY[x])").binding("a", "ARRAY[true, false]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)true), (Object)ImmutableList.of((Object)false)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> from_base(x, 16))").binding("a", "ARRAY['41', '42']")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)65L, (Object)66L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> CAST(x AS DOUBLE))").binding("a", "ARRAY['25.6E0', '27.3E0']")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)25.6, (Object)27.3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> 'abc' = x)").binding("a", "ARRAY['abc', 'def']")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x || x)").binding("a", "ARRAY['abc', 'def']")))).hasType((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())).isEqualTo(ImmutableList.of((Object)"abcabc", (Object)"defdef"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> ROW(x, CAST(x AS INTEGER), x > '3'))").binding("a", "ARRAY['123', '456']")))).hasType((Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"123", (Object)123, (Object)false), (Object)ImmutableList.of((Object)"456", (Object)456, (Object)true)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> from_base(x[3], 10))").binding("a", "ARRAY[ARRAY['abc', null, '123'], ARRAY['def', 'x', '456']]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)123L, (Object)456L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> CAST(x[3] AS DOUBLE))").binding("a", "ARRAY[ARRAY['abc', null, '123'], ARRAY['def', 'x', '456']]")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)123.0, (Object)456.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x[2] IS NULL)").binding("a", "ARRAY[ARRAY['abc', null, '123'], ARRAY['def', 'x', '456']]")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> x[2])").binding("a", "ARRAY[ARRAY['abc', null, '123'], ARRAY['def', 'x', '456']]")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))).isEqualTo(Arrays.asList(null, "x"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("transform(a, x -> map_keys(x))").binding("a", "ARRAY[MAP(ARRAY['abc', 'def'], ARRAY[123, 456]), MAP(ARRAY['ghi', 'jkl'], ARRAY[234, 567])]")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"abc", (Object)"def"), (Object)ImmutableList.of((Object)"ghi", (Object)"jkl")));
    }
}

