/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayFilterFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x = 5)").binding("a", "ARRAY[5, 6]")))).matches("ARRAY[5]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x = 5)").binding("a", "ARRAY[5 + random(1), 6 + random(1)]")))).matches("ARRAY[5]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> nullif(x, false))").binding("a", "ARRAY[true, false, true, false]")))).matches("ARRAY[true, true]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> not x)").binding("a", "ARRAY[true, false, null, true, false, null]")))).matches("ARRAY[false, false]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, t -> year(t) = 1111)").binding("a", "ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789']")))).matches("ARRAY[TIMESTAMP '1111-05-10 12:34:56.123456789']");
    }

    @Test
    public void testEmpty() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> true)").binding("a", "ARRAY[]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> false)").binding("a", "ARRAY[]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> CAST(null AS boolean))").binding("a", "ARRAY[]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> true)").binding("a", "CAST(ARRAY[] AS array(integer))")))).matches("CAST(ARRAY[] AS array(integer))");
    }

    @Test
    public void testNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x IS NULL)").binding("a", "ARRAY[NULL]")))).matches("ARRAY[NULL]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x IS NOT NULL)").binding("a", "ARRAY[NULL]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x IS NULL)").binding("a", "ARRAY[CAST(NULL AS integer)]")))).matches("CAST(ARRAY[NULL] AS array(integer))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x IS NULL)").binding("a", "ARRAY[NULL, NULL, NULL]")))).matches("ARRAY[NULL, NULL, NULL]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x IS NOT NULL)").binding("a", "ARRAY[NULL, NULL, NULL]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x % 2 = 1 OR x IS NULL)").binding("a", "ARRAY[25, 26, NULL]")))).matches("ARRAY[25, NULL]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x < 30.0E0 OR x IS NULL)").binding("a", "ARRAY[25.6E0, 37.3E0, NULL]")))).matches("ARRAY[25.6E0, NULL]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> NOT x OR x IS NULL)").binding("a", "ARRAY[true, false, NULL]")))).matches("ARRAY[false, NULL]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> substr(x, 1, 1) = 'a' OR x IS NULL)").binding("a", "ARRAY['abc', 'def', NULL]")))).matches("ARRAY['abc', NULL]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x[2] IS NULL OR x IS NULL)").binding("a", "ARRAY[ARRAY['abc', NULL, '123']]")))).matches("ARRAY[ARRAY['abc', NULL, '123']]");
    }

    @Test
    public void testTypeCombinations() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x % 2 = 1)").binding("a", "ARRAY[25, 26, 27]")))).matches("ARRAY[25, 27]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x < 30.0E0)").binding("a", "ARRAY[25.6E0, 37.3E0, 28.6E0]")))).matches("ARRAY[25.6E0, 28.6E0]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> NOT x)").binding("a", "ARRAY[true, false, true]")))).matches("ARRAY[false]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> substr(x, 1, 1) = 'a' OR x IS NULL)").binding("a", "ARRAY['abc', 'def', 'ayz']")))).matches("ARRAY['abc', 'ayz']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("filter(a, x -> x[2] IS NULL)").binding("a", "ARRAY[ARRAY['abc', NULL, '123'], ARRAY ['def', 'x', '456']]")))).matches("ARRAY[ARRAY['abc', NULL, '123']]");
    }
}

