/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.type.UnknownType;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayExceptFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[1, 5, 3]", "ARRAY[3]")))).matches("ARRAY[1, 5]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[BIGINT '1', 5, 3]", "ARRAY[5]")))).matches("ARRAY[BIGINT '1', BIGINT '3']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[VARCHAR 'x', 'y', 'z']", "ARRAY['x']")))).matches("ARRAY[VARCHAR 'y', VARCHAR 'z']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[true, false, null]", "ARRAY[true]")))).matches("ARRAY[false, null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[1.1E0, 5.4E0, 3.9E0]", "ARRAY[5, 5.4E0]")))).matches("ARRAY[1.1E0, 3.9E0]");
    }

    @Test
    public void testEmpty() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[]", "ARRAY[]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[]", "ARRAY[1, 3]")))).matches("CAST(ARRAY[] AS array(integer))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[VARCHAR 'abc']", "ARRAY[]")))).matches("ARRAY[VARCHAR 'abc']");
    }

    @Test
    public void testNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[NULL]", "NULL")))).isNull((Type)new ArrayType((Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "NULL", "NULL")))).isNull((Type)new ArrayType((Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "NULL", "ARRAY[NULL]")))).isNull((Type)new ArrayType((Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[NULL]", "ARRAY[NULL]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[]", "ARRAY[NULL]")))).matches("ARRAY[]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[NULL]", "ARRAY[]")))).matches("ARRAY[NULL]");
    }

    @Test
    public void testDuplicates() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[1, 5, 3, 5, 1]", "ARRAY[3]")))).matches("ARRAY[1, 5]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[BIGINT '1', 5, 5, 3, 3, 3, 1]", "ARRAY[3, 5]")))).matches("ARRAY[BIGINT '1']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[VARCHAR 'x', 'x', 'y', 'z']", "ARRAY['x', 'y', 'x']")))).matches("ARRAY[VARCHAR 'z']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[true, false, null, true, false, null]", "ARRAY[true, true, true]")))).matches("ARRAY[false, null]");
    }

    @Test
    public void testNonDistinctNonEqualValues() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[NaN()]", "ARRAY[NaN()]")))).matches("CAST(ARRAY[] AS array(double))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("array_except", "ARRAY[1, NaN(), 3]", "ARRAY[NaN(), 3]")))).matches("ARRAY[1E0]");
    }
}

