/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.scalar.BlockSet;
import io.trino.spi.Page;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayDistinct {
    private static final int POSITIONS = 100000;
    private static final int ARRAY_SIZE = 2;
    private static final int NUM_TYPES = 1;
    private static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);
    private static final BlockTypeOperators BLOCK_TYPE_OPERATORS = new BlockTypeOperators(new TypeOperators());
    private static final BlockTypeOperators.BlockPositionIsDistinctFrom DISTINCT_FROM_OPERATOR = BLOCK_TYPE_OPERATORS.getDistinctFromOperator((Type)VarcharType.VARCHAR);
    private static final BlockTypeOperators.BlockPositionHashCode HASH_CODE_OPERATOR = BLOCK_TYPE_OPERATORS.getHashCodeOperator((Type)VarcharType.VARCHAR);

    @Benchmark
    @OperationsPerInvocation(value=200000)
    public List<Optional<Page>> arrayDistinct(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayDistinct().arrayDistinct(data);
        Benchmarks.benchmark(BenchmarkArrayDistinct.class).run();
    }

    @ScalarFunction
    @SqlType(value="array(varchar)")
    public static Block oldArrayDistinct(@SqlType(value="array(varchar)") Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        BlockSet set = new BlockSet((Type)VarcharType.VARCHAR, DISTINCT_FROM_OPERATOR, HASH_CODE_OPERATOR, array.getPositionCount());
        VariableWidthBlockBuilder distinctElementBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, array.getPositionCount());
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (!set.add(array, i)) continue;
            VarcharType.VARCHAR.appendTo(array, i, (BlockBuilder)distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }

    static {
        Verify.verify((1 == TYPES.size() ? 1 : 0) != 0);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"array_distinct", "old_array_distinct"})
        private String name = "array_distinct";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            TestingFunctionResolution functionResolution = new TestingFunctionResolution((FunctionBundle)InternalFunctionBundle.extractFunctions(BenchmarkArrayDistinct.class));
            ExpressionCompiler compiler = functionResolution.getExpressionCompiler();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[TYPES.size()];
            for (int i = 0; i < TYPES.size(); ++i) {
                Type elementType = TYPES.get(i);
                ArrayType arrayType = new ArrayType(elementType);
                projectionsBuilder.add((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)this.name), TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType})), (List)ImmutableList.of((Object)Expressions.field((int)i, (Type)arrayType))));
                blocks[i] = BenchmarkData.createChannel(100000, 2, arrayType);
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType) {
            ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                blockBuilder.buildEntry(elementBuilder -> {
                    for (int i = 0; i < arraySize; ++i) {
                        if (arrayType.getElementType().getJavaType() == Long.TYPE) {
                            arrayType.getElementType().writeLong(elementBuilder, ThreadLocalRandom.current().nextLong());
                            continue;
                        }
                        if (arrayType.getElementType().equals(VarcharType.VARCHAR)) {
                            arrayType.getElementType().writeSlice(elementBuilder, Slices.utf8Slice((String)"test_string"));
                            continue;
                        }
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

