/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.histogram;

import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.histogram.ValueStore;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.type.BlockTypeOperators;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestValueStore {
    private ValueStore valueStore;
    private Block block;
    private BlockTypeOperators.BlockPositionHashCode hashCodeOperator;
    private ValueStore valueStoreSmall;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        VarcharType type = VarcharType.createVarcharType((int)100);
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(new TypeOperators());
        BlockTypeOperators.BlockPositionEqual equalOperator = blockTypeOperators.getEqualOperator((Type)type);
        this.hashCodeOperator = blockTypeOperators.getHashCodeOperator((Type)type);
        VariableWidthBlockBuilder blockBuilder = type.createBlockBuilder(null, 100, 10);
        this.valueStore = new ValueStore((Type)type, equalOperator, 100, (BlockBuilder)blockBuilder);
        this.valueStoreSmall = new ValueStore((Type)type, equalOperator, 1, (BlockBuilder)blockBuilder);
        this.block = BlockAssertions.createStringsBlock("a", "b", "c", "d");
    }

    @Test
    public void testUniqueness() {
        Assert.assertEquals((int)this.valueStore.addAndGetPosition(this.block, 0, this.hashCodeOperator.hashCode(this.block, 0)), (int)0);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition(this.block, 1, this.hashCodeOperator.hashCode(this.block, 1)), (int)1);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition(this.block, 2, this.hashCodeOperator.hashCode(this.block, 2)), (int)2);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition(this.block, 1, this.hashCodeOperator.hashCode(this.block, 1)), (int)1);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition(this.block, 3, this.hashCodeOperator.hashCode(this.block, 1)), (int)3);
    }

    @Test
    public void testTriggerRehash() {
        long hash0 = this.hashCodeOperator.hashCode(this.block, 0);
        long hash1 = this.hashCodeOperator.hashCode(this.block, 1);
        long hash2 = this.hashCodeOperator.hashCode(this.block, 2);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition(this.block, 0, hash0), (int)0);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition(this.block, 1, hash1), (int)1);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition(this.block, 2, hash2), (int)2);
        Assert.assertTrue((this.valueStoreSmall.getRehashCount() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition(this.block, 0, hash0), (int)0);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition(this.block, 1, hash1), (int)1);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition(this.block, 2, hash2), (int)2);
    }
}

