/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestDecimalSumAggregation;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.util.List;

public class TestShortDecimalSumAggregation
extends AbstractTestDecimalSumAggregation {
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)16, (int)2);

    @Override
    protected DecimalType getDecimalType() {
        return SHORT_DECIMAL_TYPE;
    }

    @Override
    protected DecimalType getExpectedType() {
        return DecimalType.createDecimalType((int)38, (int)2);
    }

    @Override
    protected void writeDecimalToBlock(BigDecimal decimal, BlockBuilder blockBuilder) {
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, decimal.unscaledValue().longValue());
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)SHORT_DECIMAL_TYPE);
    }
}

