/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.trino.operator.aggregation.NumericHistogram;
import java.util.HashSet;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestNumericHistogram {
    @Test
    public void testBasic() {
        double[] data = new double[]{2.9, 3.1, 3.4, 3.5, 3.1, 2.9, 3.0, 3.8, 3.6, 3.1, 3.6, 2.5, 2.8, 2.3, 3.0, 3.0, 3.2, 3.8, 2.6, 2.9, 3.9, 3.5, 2.2, 2.9, 3.0, 3.2, 3.4, 3.2, 3.0, 4.2, 3.0, 2.9, 4.4, 2.4, 3.9, 2.8, 3.1, 3.2, 3.0, 3.0, 3.7, 2.9, 3.0, 3.1, 2.5, 3.3, 2.7, 3.0, 3.1, 3.0, 2.8, 3.0, 3.5, 2.6, 3.2, 2.6, 2.9, 4.0, 2.8, 3.2, 2.8, 3.2, 3.4, 2.8, 3.7, 3.8, 2.7, 3.3, 2.5, 2.8, 2.4, 2.9, 3.0, 2.7, 3.8, 2.8, 3.0, 3.0, 3.5, 3.4, 3.4, 3.4, 3.0, 3.8, 2.9, 3.0, 3.6, 3.1, 3.4, 2.7, 2.5, 2.5, 3.2, 2.7, 2.3, 3.3, 2.2, 3.7, 3.5, 2.7, 2.8, 3.4, 2.9, 3.4, 3.0, 2.8, 2.7, 3.1, 3.5, 3.3, 3.2, 3.1, 3.2, 3.6, 3.0, 3.2, 3.0, 2.5, 3.1, 3.0, 3.0, 2.7, 2.7, 2.6, 3.0, 2.3, 3.3, 2.8, 3.2, 3.4, 2.8, 3.0, 3.1, 2.0, 3.0, 2.5, 2.4, 3.3, 2.3, 3.0, 2.8, 2.8, 2.6, 3.8, 3.2, 3.4, 2.5, 4.1, 2.2, 3.4};
        NumericHistogram histogram = new NumericHistogram(4, data.length);
        HashSet<Double> uniqueValues = new HashSet<Double>();
        for (double value : data) {
            histogram.add(value);
            uniqueValues.add(value);
            if (uniqueValues.size() != 8) continue;
            histogram.compact();
            uniqueValues.clear();
        }
        ImmutableMap expected = ImmutableMap.builder().put((Object)2.4571428571428564, (Object)28.0).put((Object)3.568571428571429, (Object)35.0).put((Object)3.0023809523809515, (Object)84.0).put((Object)4.233333333333333, (Object)3.0).buildOrThrow();
        Assert.assertEquals((Map)histogram.getBuckets(), (Map)expected);
    }

    @Test
    public void testSameValues() {
        NumericHistogram histogram = new NumericHistogram(4);
        for (int i = 0; i < 100; ++i) {
            histogram.add(1.0, 3.0);
            histogram.add(2.0, 5.0);
        }
        ImmutableMap expected = ImmutableMap.builder().put((Object)1.0, (Object)300.0).put((Object)2.0, (Object)500.0).buildOrThrow();
        Assert.assertEquals((Map)histogram.getBuckets(), (Map)expected);
    }

    @Test
    public void testRoundtrip() {
        NumericHistogram histogram = new NumericHistogram(100, 20);
        for (int i = 0; i < 1000; ++i) {
            histogram.add((double)i);
        }
        Slice serialized = histogram.serialize();
        NumericHistogram deserialized = new NumericHistogram(serialized, 20);
        Assert.assertEquals((Map)deserialized.getBuckets(), (Map)histogram.getBuckets());
    }

    @Test
    public void testMergeSame() {
        NumericHistogram histogram = new NumericHistogram(10, 3);
        for (int i = 0; i < 1000; ++i) {
            histogram.add((double)i);
        }
        Map expected = Maps.transformValues((Map)histogram.getBuckets(), value -> value * 2.0);
        histogram.mergeWith(histogram);
        Assert.assertEquals((Map)histogram.getBuckets(), (Map)expected);
    }

    @Test
    public void testMergeDifferent() {
        NumericHistogram histogram1 = new NumericHistogram(10, 3);
        NumericHistogram histogram2 = new NumericHistogram(10, 3);
        for (int i = 0; i < 1000; ++i) {
            histogram1.add((double)i);
            histogram2.add((double)(i + 1000));
        }
        NumericHistogram expected = new NumericHistogram(10, 1000);
        for (Map.Entry entry : histogram1.getBuckets().entrySet()) {
            expected.add(((Double)entry.getKey()).doubleValue(), ((Double)entry.getValue()).doubleValue());
        }
        for (Map.Entry entry : histogram2.getBuckets().entrySet()) {
            expected.add(((Double)entry.getKey()).doubleValue(), ((Double)entry.getValue()).doubleValue());
        }
        expected.compact();
        histogram1.mergeWith(histogram2);
        Assert.assertEquals((Map)histogram1.getBuckets(), (Map)expected.getBuckets());
    }
}

