/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.Variance;

public class TestLongVarianceAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Number getExpectedValue(int start, int length) {
        if (length < 2) {
            return null;
        }
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = start + i;
        }
        Variance variance = new Variance();
        return variance.evaluate(values);
    }

    @Override
    protected String getFunctionName() {
        return "variance";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)BigintType.BIGINT);
    }
}

