/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import java.util.List;

public class TestDoubleMinAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return (double)start;
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DoubleType.DOUBLE);
    }
}

