/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.FeaturesConfig;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metadata.TypeRegistry;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestArbitraryAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testAllRegistered() {
        Collection standardTypes = new TypeRegistry(new TypeOperators(), new FeaturesConfig()).getTypes();
        for (Type valueType : standardTypes) {
            Assert.assertNotNull((Object)FUNCTION_RESOLUTION.getAggregateFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType})));
        }
    }

    @Test
    public void testNullBoolean() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN}), null, BlockAssertions.createBooleansBlock(new Boolean[]{null}));
    }

    @Test
    public void testValidBoolean() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN}), (Object)true, BlockAssertions.createBooleansBlock(true, true));
    }

    @Test
    public void testNullLong() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}), null, BlockAssertions.createLongsBlock(null, null));
    }

    @Test
    public void testValidLong() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}), (Object)1L, BlockAssertions.createLongsBlock(1L, null));
    }

    @Test
    public void testNullDouble() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}), null, BlockAssertions.createDoublesBlock(null, null));
    }

    @Test
    public void testValidDouble() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}), (Object)2.0, BlockAssertions.createDoublesBlock(null, 2.0));
    }

    @Test
    public void testNullString() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}), null, BlockAssertions.createStringsBlock(null, null));
    }

    @Test
    public void testValidString() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}), (Object)"a", BlockAssertions.createStringsBlock("a", "a"));
    }

    @Test
    public void testNullArray() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)}), null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null, null)));
    }

    @Test
    public void testValidArray() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)}), (Object)ImmutableList.of((Object)23L, (Object)45L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L))));
    }

    @Test
    public void testValidInt() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"arbitrary"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER}), (Object)3, BlockAssertions.createIntsBlock(3, 3, null));
    }
}

