/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import io.trino.operator.aggregation.AbstractTestApproximateSetGeneric;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestApproximateSetGenericBoolean
extends AbstractTestApproximateSetGeneric {
    @Override
    protected Type getValueType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    protected Object randomValue() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @DataProvider(name="inputSequences")
    public Object[][] inputSequences() {
        return new Object[][]{{true}, {false}, {true, false}, {true, true, true}, {false, false, false}, {true, false, true, false}};
    }

    @Test(dataProvider="inputSequences")
    public void testNonEmptyInputs(boolean ... inputSequence) {
        List values = Booleans.asList((boolean[])inputSequence);
        this.assertCount(values, this.distinctCount(values));
    }

    private long distinctCount(List<Boolean> inputSequence) {
        return ImmutableSet.copyOf(inputSequence).size();
    }

    @Override
    protected int getUniqueValuesCount() {
        return 2;
    }

    @Override
    protected List<Object> getResultStabilityTestSample() {
        return ImmutableList.of((Object)true, (Object)false);
    }

    @Override
    protected String getResultStabilityExpected() {
        return "020C020080034400802008DE";
    }
}

