/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AggregationMask;
import io.trino.operator.aggregation.AggregationMaskBuilder;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class InterpretedAggregationMaskBuilder
implements AggregationMaskBuilder {
    private final List<ChannelNullCheck> nullChecks;
    private int[] selectedPositions = new int[0];

    public InterpretedAggregationMaskBuilder(int ... nonNullArguments) {
        this.nullChecks = (List)Arrays.stream(nonNullArguments).mapToObj(ChannelNullCheck::new).collect(ImmutableList.toImmutableList());
    }

    public AggregationMask buildAggregationMask(Page arguments, Optional<Block> optionalMaskBlock) {
        boolean maskBlockMayHaveNull;
        int positionCount = arguments.getPositionCount();
        if (positionCount == 0) {
            return AggregationMask.createSelectNone((int)positionCount);
        }
        Block maskBlock = optionalMaskBlock.orElse(null);
        boolean hasMaskBlock = maskBlock != null;
        boolean bl = maskBlockMayHaveNull = hasMaskBlock && maskBlock.mayHaveNull();
        if (maskBlock instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock rle = (RunLengthEncodedBlock)maskBlock;
            if (!InterpretedAggregationMaskBuilder.testMaskBlock(rle.getValue(), maskBlockMayHaveNull, 0)) {
                return AggregationMask.createSelectNone((int)positionCount);
            }
            hasMaskBlock = false;
            maskBlockMayHaveNull = false;
        }
        for (ChannelNullCheck nullCheck : this.nullChecks) {
            nullCheck.reset(arguments);
            if (!nullCheck.isAlwaysNull()) continue;
            return AggregationMask.createSelectNone((int)positionCount);
        }
        if (!hasMaskBlock && this.nullChecks.stream().noneMatch(ChannelNullCheck::mayHaveNull)) {
            return AggregationMask.createSelectAll((int)positionCount);
        }
        int[] selectedPositions = this.selectedPositions;
        if (selectedPositions.length < positionCount) {
            this.selectedPositions = selectedPositions = new int[positionCount];
        }
        int selectedPositionsIndex = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = i;
            if (!InterpretedAggregationMaskBuilder.testMaskBlock(maskBlock, maskBlockMayHaveNull, position) || !this.nullChecks.stream().allMatch(arg -> arg.isNotNull(position))) continue;
            selectedPositions[selectedPositionsIndex] = position;
            ++selectedPositionsIndex;
        }
        return AggregationMask.createSelectedPositions((int)positionCount, (int[])selectedPositions, (int)selectedPositionsIndex);
    }

    private static boolean testMaskBlock(Block block, boolean mayHaveNulls, int position) {
        if (block == null) {
            return true;
        }
        if (mayHaveNulls && block.isNull(position)) {
            return false;
        }
        return block.getByte(position, 0) != 0;
    }

    private static final class ChannelNullCheck {
        private final int channel;
        private Block block;
        private boolean mayHaveNull;

        public ChannelNullCheck(int channel) {
            this.channel = channel;
        }

        public void reset(Page arguments) {
            this.block = arguments.getBlock(this.channel);
            this.mayHaveNull = this.block.mayHaveNull();
        }

        public boolean mayHaveNull() {
            return this.mayHaveNull;
        }

        private boolean isAlwaysNull() {
            Block block = this.block;
            if (block instanceof RunLengthEncodedBlock) {
                RunLengthEncodedBlock rle = (RunLengthEncodedBlock)block;
                return rle.getValue().isNull(0);
            }
            return false;
        }

        private boolean isNotNull(int position) {
            return !this.mayHaveNull || !this.block.isNull(position);
        }
    }
}

