/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestRealAverageAggregation
extends AbstractTestAggregationFunction {
    @Test
    public void averageOfNullIsNull() {
        AggregationTestUtils.assertAggregation(this.functionResolution, QualifiedName.of((String)"avg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL}), null, BlockAssertions.createBlockOfReals(null, null));
    }

    @Test
    public void averageOfSingleValueEqualsThatValue() {
        AggregationTestUtils.assertAggregation(this.functionResolution, QualifiedName.of((String)"avg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL}), (Object)Float.valueOf(1.23f), BlockAssertions.createBlockOfReals(Float.valueOf(1.23f)));
    }

    @Test
    public void averageOfTwoMaxFloatsEqualsMaxFloat() {
        AggregationTestUtils.assertAggregation(this.functionResolution, QualifiedName.of((String)"avg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{RealType.REAL}), (Object)Float.valueOf(Float.MAX_VALUE), BlockAssertions.createBlockOfReals(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MAX_VALUE)));
    }

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)RealType.REAL);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        float sum = 0.0f;
        for (int i = start; i < start + length; ++i) {
            sum += (float)i;
        }
        return Float.valueOf(sum / (float)length);
    }
}

