/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.block.BlockAssertions;
import io.trino.operator.PageUtils;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageUtils {
    @Test
    public void testRecordMaterializedBytes() {
        Block first = BlockAssertions.createIntsBlock(1, 2, 3);
        LazyBlock second = TestPageUtils.lazyWrapper(first);
        LazyBlock third = TestPageUtils.lazyWrapper(first);
        Page page = new Page(3, new Block[]{first, second, third});
        second.getLoadedBlock();
        AtomicLong sizeInBytes = new AtomicLong();
        PageUtils.recordMaterializedBytes((Page)page, sizeInBytes::getAndAdd);
        Assert.assertEquals((long)sizeInBytes.get(), (long)(first.getSizeInBytes() * 2L));
        page.getBlock(2).getLoadedBlock();
        Assert.assertEquals((long)sizeInBytes.get(), (long)(first.getSizeInBytes() * 3L));
    }

    @Test
    public void testNestedBlocks() {
        LazyBlock elements = TestPageUtils.lazyWrapper(BlockAssertions.createIntsBlock(1, 2, 3));
        Block dictBlock = DictionaryBlock.create((int)2, (Block)elements, (int[])new int[]{0, 0});
        Page page = new Page(2, new Block[]{dictBlock});
        AtomicLong sizeInBytes = new AtomicLong();
        PageUtils.recordMaterializedBytes((Page)page, sizeInBytes::getAndAdd);
        Assert.assertEquals((long)sizeInBytes.get(), (long)dictBlock.getSizeInBytes());
        dictBlock.getLoadedBlock();
        Assert.assertEquals((long)sizeInBytes.get(), (long)(dictBlock.getSizeInBytes() + elements.getSizeInBytes()));
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }
}

