/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.OperatorInfo;
import io.trino.operator.OperatorStats;
import io.trino.operator.SplitOperatorInfo;
import io.trino.operator.output.PartitionedOutputOperator;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOperatorStats {
    private static final SplitOperatorInfo NON_MERGEABLE_INFO = new SplitOperatorInfo(TestingHandles.TEST_CATALOG_HANDLE, (Object)"some_info");
    private static final PartitionedOutputOperator.PartitionedOutputInfo MERGEABLE_INFO = new PartitionedOutputOperator.PartitionedOutputInfo(1L, 2L, 1024L);
    public static final OperatorStats EXPECTED = new OperatorStats(0, 1, 41, new PlanNodeId("test"), "test", 1L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)51L), 511L, new Duration(5.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)52L), 522L, DataSize.ofBytes((long)5L), DataSize.ofBytes((long)6L), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)12L), 13L, 533L, new Metrics((Map)ImmutableMap.of((Object)"metrics", (Object)new LongCount(42L))), new Metrics((Map)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(43L))), DataSize.ofBytes((long)14L), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), DataSize.ofBytes((long)22L), DataSize.ofBytes((long)24L), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)26L), Optional.empty(), (OperatorInfo)NON_MERGEABLE_INFO);
    public static final OperatorStats MERGEABLE = new OperatorStats(0, 1, 41, new PlanNodeId("test"), "test", 1L, 2L, new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)51L), 511L, new Duration(5.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)52L), 522L, DataSize.ofBytes((long)5L), DataSize.ofBytes((long)6L), 7L, 8.0, 9L, new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)12L), 13L, 533L, new Metrics((Map)ImmutableMap.of((Object)"metrics", (Object)new LongCount(42L))), new Metrics((Map)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(43L))), DataSize.ofBytes((long)14L), new Duration(15.0, TimeUnit.NANOSECONDS), 16L, new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)19L), DataSize.ofBytes((long)20L), DataSize.ofBytes((long)22L), DataSize.ofBytes((long)24L), DataSize.ofBytes((long)25L), DataSize.ofBytes((long)26L), Optional.empty(), (OperatorInfo)MERGEABLE_INFO);

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(OperatorStats.class);
        String json = codec.toJson((Object)EXPECTED);
        OperatorStats actual = (OperatorStats)codec.fromJson(json);
        TestOperatorStats.assertExpectedOperatorStats(actual);
    }

    public static void assertExpectedOperatorStats(OperatorStats actual) {
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)1L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)2L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(3.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)51L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)511L);
        Assert.assertEquals((Object)actual.getPhysicalInputReadTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)52L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)522L);
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)5L));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)DataSize.ofBytes((long)6L));
        Assert.assertEquals((long)actual.getInputPositions(), (long)7L);
        Assert.assertEquals((Object)actual.getSumSquaredInputPositions(), (Object)8.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)9L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)12L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)13L);
        Assert.assertEquals((long)actual.getDynamicFilterSplitsProcessed(), (long)533L);
        Assert.assertEquals((Map)actual.getMetrics().getMetrics(), (Map)ImmutableMap.of((Object)"metrics", (Object)new LongCount(42L)));
        Assert.assertEquals((Map)actual.getConnectorMetrics().getMetrics(), (Map)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(43L)));
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)14L));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)16L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)19L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)20L));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)DataSize.ofBytes((long)22L));
        Assert.assertEquals((Object)actual.getPeakRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)24L));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)DataSize.ofBytes((long)25L));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)DataSize.ofBytes((long)26L));
        Assert.assertEquals(actual.getInfo().getClass(), SplitOperatorInfo.class);
        Assert.assertEquals((Object)((SplitOperatorInfo)actual.getInfo()).getSplitInfo(), (Object)NON_MERGEABLE_INFO.getSplitInfo());
    }

    @Test
    public void testAdd() {
        OperatorStats actual = EXPECTED.add((Iterable)ImmutableList.of((Object)EXPECTED, (Object)EXPECTED));
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)153L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)1533L);
        Assert.assertEquals((Object)actual.getPhysicalInputReadTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)156L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)1566L);
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)15L));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)DataSize.ofBytes((long)18L));
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((Object)actual.getSumSquaredInputPositions(), (Object)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)36L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((long)actual.getDynamicFilterSplitsProcessed(), (long)1599L);
        Assert.assertEquals((Map)actual.getMetrics().getMetrics(), (Map)ImmutableMap.of((Object)"metrics", (Object)new LongCount(126L)));
        Assert.assertEquals((Map)actual.getConnectorMetrics().getMetrics(), (Map)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(129L)));
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)42L));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)57L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)60L));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)DataSize.ofBytes((long)22L));
        Assert.assertEquals((Object)actual.getPeakRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)24L));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)DataSize.ofBytes((long)25L));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)DataSize.ofBytes((long)78L));
        Assert.assertNull((Object)actual.getInfo());
    }

    @Test
    public void testAddMergeable() {
        OperatorStats actual = MERGEABLE.add((Iterable)ImmutableList.of((Object)MERGEABLE, (Object)MERGEABLE));
        Assert.assertEquals((int)actual.getStageId(), (int)0);
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getTotalDrivers(), (long)3L);
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)6L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)153L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)1533L);
        Assert.assertEquals((Object)actual.getPhysicalInputReadTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)156L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)1566L);
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)15L));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)DataSize.ofBytes((long)18L));
        Assert.assertEquals((long)actual.getInputPositions(), (long)21L);
        Assert.assertEquals((Object)actual.getSumSquaredInputPositions(), (Object)24.0);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)27L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(33.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)36L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)39L);
        Assert.assertEquals((long)actual.getDynamicFilterSplitsProcessed(), (long)1599L);
        Assert.assertEquals((Map)actual.getMetrics().getMetrics(), (Map)ImmutableMap.of((Object)"metrics", (Object)new LongCount(126L)));
        Assert.assertEquals((Map)actual.getConnectorMetrics().getMetrics(), (Map)ImmutableMap.of((Object)"connectorMetrics", (Object)new LongCount(129L)));
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)42L));
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)48L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(54.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)57L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)60L));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)DataSize.ofBytes((long)22L));
        Assert.assertEquals((Object)actual.getPeakRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)24L));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)DataSize.ofBytes((long)25L));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)DataSize.ofBytes((long)78L));
        Assert.assertEquals(actual.getInfo().getClass(), PartitionedOutputOperator.PartitionedOutputInfo.class);
        Assert.assertEquals((long)((PartitionedOutputOperator.PartitionedOutputInfo)actual.getInfo()).getPagesAdded(), (long)(3L * MERGEABLE_INFO.getPagesAdded()));
    }
}

