/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.IdRegistry;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIdRegistry {
    @Test
    public void testAllocateDeallocate() {
        IdRegistry registry = new IdRegistry();
        int id1 = Integer.parseInt((String)registry.allocateId(Integer::toString));
        Assert.assertEquals((String)((String)registry.get(id1)), (String)Integer.toString(id1));
        int id2 = Integer.parseInt((String)registry.allocateId(Integer::toString));
        Assert.assertEquals((String)((String)registry.get(id1)), (String)Integer.toString(id1));
        Assert.assertEquals((String)((String)registry.get(id2)), (String)Integer.toString(id2));
        registry.deallocate(id1);
        Assert.assertEquals((String)((String)registry.get(id2)), (String)Integer.toString(id2));
    }

    @Test
    public void testBulkAllocate() {
        int i;
        IdRegistry registry = new IdRegistry();
        IntArrayList ids = new IntArrayList();
        for (i = 0; i < 100; ++i) {
            ids.add(Integer.parseInt((String)registry.allocateId(Integer::toString)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((String)((String)registry.get(ids.getInt(i))), (String)Integer.toString(i));
        }
        for (i = 0; i < 100; ++i) {
            registry.deallocate(ids.getInt(i));
        }
    }

    @Test
    public void testIdRecycling() {
        IdRegistry registry = new IdRegistry();
        int id1 = Integer.parseInt((String)registry.allocateId(Integer::toString));
        registry.deallocate(id1);
        int id2 = Integer.parseInt((String)registry.allocateId(Integer::toString));
        Assert.assertEquals((int)id1, (int)id2);
        int id3 = Integer.parseInt((String)registry.allocateId(Integer::toString));
        registry.allocateId(Integer::toString);
        registry.deallocate(id3);
        registry.allocateId(Integer::toString);
        Assert.assertEquals((int)id3, (int)id3);
    }
}

