/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.RowPagesBuilder;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupedTopNRowNumberBuilder;
import io.trino.operator.NoChannelGroupByHash;
import io.trino.operator.PageAssertions;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.SimplePageWithPositionComparator;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGroupedTopNRowNumberBuilder {
    private static final TypeOperators TYPE_OPERATORS_CACHE = new TypeOperators();

    @DataProvider
    public static Object[][] produceRowNumbers() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider
    public static Object[][] pageRowCounts() {
        return new Object[][]{{10000, 20}, {20, 10000}};
    }

    @Test
    public void testEmptyInput() {
        GroupedTopNRowNumberBuilder groupedTopNBuilder = new GroupedTopNRowNumberBuilder((List)ImmutableList.of((Object)BigintType.BIGINT), (left, leftPosition, right, rightPosition) -> {
            throw new UnsupportedOperationException();
        }, 5, false, (GroupByHash)new NoChannelGroupByHash());
        Assert.assertFalse((boolean)groupedTopNBuilder.buildResult().hasNext());
    }

    @Test(dataProvider="produceRowNumbers")
    public void testMultiGroupTopN(boolean produceRowNumbers) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(2L, 0.2).row(3L, 0.9).row(3L, 0.1).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(4L, 0.6).row(2L, 0.8).row(2L, 0.7).pageBreak().row(2L, 0.9).build();
        for (Page page : input) {
            page.compact();
        }
        GroupByHash groupByHash = TestGroupedTopNRowNumberBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), UpdateMemory.NOOP);
        GroupedTopNRowNumberBuilder groupedTopNBuilder = new GroupedTopNRowNumberBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), TYPE_OPERATORS_CACHE), 2, produceRowNumbers, groupByHash);
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(0)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(1)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(2)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(3)).process());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT}).row(1L, 0.3, 1).row(1L, 0.4, 2).row(2L, 0.2, 1).row(2L, 0.7, 2).row(3L, 0.1, 1).row(3L, 0.9, 2).row(4L, 0.6, 1).build().get(0);
        if (produceRowNumbers) {
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), (Page)output.get(0), expected);
        } else {
            PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), new Page(new Block[]{expected.getBlock(0), expected.getBlock(1)}));
        }
    }

    @Test(dataProvider="produceRowNumbers")
    public void testSingleGroupTopN(boolean produceRowNumbers) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(2L, 0.2).row(3L, 0.9).row(3L, 0.1).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(4L, 0.6).row(2L, 0.8).row(2L, 0.7).pageBreak().row(2L, 0.9).build();
        for (Page page : input) {
            page.compact();
        }
        GroupedTopNRowNumberBuilder groupedTopNBuilder = new GroupedTopNRowNumberBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), TYPE_OPERATORS_CACHE), 5, produceRowNumbers, (GroupByHash)new NoChannelGroupByHash());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(0)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(1)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(2)).process());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(3)).process());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT}).row(3L, 0.1, 1).row(2L, 0.2, 2).row(1L, 0.3, 3).row(1L, 0.4, 4).row(1L, 0.5, 5).build().get(0);
        if (produceRowNumbers) {
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), (Page)output.get(0), expected);
        } else {
            PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), new Page(new Block[]{expected.getBlock(0), expected.getBlock(1)}));
        }
    }

    @Test
    public void testYield() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        Page input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(1L, 0.2).row(1L, 0.9).row(1L, 0.1).build().get(0);
        input.compact();
        AtomicBoolean unblock = new AtomicBoolean();
        GroupByHash groupByHash = TestGroupedTopNRowNumberBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), unblock::get);
        GroupedTopNRowNumberBuilder groupedTopNBuilder = new GroupedTopNRowNumberBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), TYPE_OPERATORS_CACHE), 5, false, groupByHash);
        Work work = groupedTopNBuilder.processPage(input);
        Assert.assertFalse((boolean)work.process());
        Assert.assertFalse((boolean)work.process());
        unblock.set(true);
        Assert.assertTrue((boolean)work.process());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.1).row(1L, 0.2).row(1L, 0.3).row(1L, 0.9).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), expected);
    }

    private static GroupByHash createGroupByHash(List<Type> partitionTypes, List<Integer> partitionChannels, UpdateMemory updateMemory) {
        TypeOperators typeOperators = new TypeOperators();
        return GroupByHash.createGroupByHash(partitionTypes, (int[])Ints.toArray(partitionChannels), Optional.empty(), (int)1, (boolean)false, (JoinCompiler)new JoinCompiler(typeOperators), (BlockTypeOperators)new BlockTypeOperators(typeOperators), (UpdateMemory)updateMemory);
    }
}

