/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.GroupIdOperator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestGroupIdOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testGroupId() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)ImmutableList.of(), new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 100, 400, 0, 1000).addSequencePage(3, 200, 500, 0, 1100).build();
        GroupIdOperator.GroupIdOperatorFactory operatorFactory = new GroupIdOperator.GroupIdOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableMap.of((Object)0, (Object)1, (Object)1, (Object)2, (Object)3, (Object)0), (Object)ImmutableMap.of((Object)2, (Object)3, (Object)3, (Object)0)));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"400", true, null, 100L, 0L}).row(new Object[]{"401", false, null, 101L, 0L}).row(new Object[]{"402", true, null, 102L, 0L}).row(new Object[]{"500", true, null, 200L, 0L}).row(new Object[]{"501", false, null, 201L, 0L}).row(new Object[]{"502", true, null, 202L, 0L}).row(new Object[]{null, null, 1000L, 100L, 1L}).row(new Object[]{null, null, 1001L, 101L, 1L}).row(new Object[]{null, null, 1002L, 102L, 1L}).row(new Object[]{null, null, 1100L, 200L, 1L}).row(new Object[]{null, null, 1101L, 201L, 1L}).row(new Object[]{null, null, 1102L, 202L, 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }
}

