/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.DirectExchangeClientConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDirectExchangeClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DirectExchangeClientConfig)ConfigAssertions.recordDefaults(DirectExchangeClientConfig.class)).setMaxBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setConcurrentRequestMultiplier(3).setMaxErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setMaxResponseSize(new HttpClientConfig().getMaxContentLength()).setPageBufferClientMaxCallbackThreads(25).setClientThreads(25).setAcknowledgePages(true).setDeduplicationBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"exchange.max-buffer-size", (Object)"1GB").put((Object)"exchange.concurrent-request-multiplier", (Object)"13").put((Object)"exchange.max-error-duration", (Object)"33s").put((Object)"exchange.max-response-size", (Object)"1MB").put((Object)"exchange.client-threads", (Object)"2").put((Object)"exchange.page-buffer-client.max-callback-threads", (Object)"16").put((Object)"exchange.acknowledge-pages", (Object)"false").put((Object)"exchange.deduplication-buffer-size", (Object)"2MB").buildOrThrow();
        DirectExchangeClientConfig expected = new DirectExchangeClientConfig().setMaxBufferSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setConcurrentRequestMultiplier(13).setMaxErrorDuration(new Duration(33.0, TimeUnit.SECONDS)).setMaxResponseSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setClientThreads(2).setPageBufferClientMaxCallbackThreads(16).setAcknowledgePages(false).setDeduplicationBufferSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

