/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.CyclingGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCyclingGroupByHash {
    @Test
    public void testSingleGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(1);
        Page page = TestCyclingGroupByHash.createPage(1);
        int[] groupByIds = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIds, 0);
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)1);
        page = TestCyclingGroupByHash.createPage(2);
        groupByIds = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIds, 0, 0);
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)1);
    }

    @Test
    public void testMultipleGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(2);
        Page page = TestCyclingGroupByHash.createPage(3);
        int[] groupByIds = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIds, 0, 1, 0);
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)2);
        page = TestCyclingGroupByHash.createPage(2);
        groupByIds = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIds, 1, 0);
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)2);
    }

    @Test
    public void testPartialGroup() {
        CyclingGroupByHash groupByHash = new CyclingGroupByHash(3);
        Page page = TestCyclingGroupByHash.createPage(2);
        int[] groupByIds = TestCyclingGroupByHash.computeGroupByIdBlock(groupByHash, page);
        TestCyclingGroupByHash.assertGrouping(groupByIds, 0, 1);
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)2);
    }

    private static void assertGrouping(int[] groupIds, int ... expectedGroupIds) {
        Assert.assertEquals((Object)groupIds, (Object)expectedGroupIds);
    }

    private static int[] computeGroupByIdBlock(GroupByHash groupByHash, Page page) {
        Work groupIds = groupByHash.getGroupIds(page);
        while (!groupIds.process()) {
        }
        return (int[])groupIds.getResult();
    }

    private static Page createPage(int positionCount) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        Block block = blockBuilder.build();
        return new Page(new Block[]{block});
    }
}

