/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResolvedFunction {
    private static final Pattern VARCHAR_MATCHER = Pattern.compile("varchar\\(([0-9]+)\\)");

    @Test
    public void test() {
        ResolvedFunction resolvedFunction = TestResolvedFunction.createResolvedFunction("top", 3);
        ResolvedFunction.ResolvedFunctionDecoder decoder = new ResolvedFunction.ResolvedFunctionDecoder(TestResolvedFunction::varcharTypeLoader);
        Optional copy = decoder.fromQualifiedName(resolvedFunction.toQualifiedName());
        Assert.assertTrue((boolean)copy.isPresent());
        Assert.assertEquals(copy.get(), (Object)resolvedFunction);
    }

    private static ResolvedFunction createResolvedFunction(String name, int depth) {
        return new ResolvedFunction(new BoundSignature(name + "_" + depth, (Type)VarcharType.createVarcharType((int)(10 + depth)), (List)ImmutableList.of((Object)VarcharType.createVarcharType((int)(20 + depth)), (Object)VarcharType.createVarcharType((int)(30 + depth)))), GlobalSystemConnector.CATALOG_HANDLE, FunctionId.toFunctionId((Signature)Signature.builder().name(name).returnType(new TypeSignature("x", new TypeSignatureParameter[0])).argumentType(new TypeSignature("y", new TypeSignatureParameter[0])).argumentType(new TypeSignature("z", new TypeSignatureParameter[0])).build()), FunctionKind.SCALAR, true, new FunctionNullability(false, (List)ImmutableList.of((Object)false, (Object)false)), (Map)ImmutableSet.of((Object)VarcharType.createVarcharType((int)11), (Object)VarcharType.createVarcharType((int)12), (Object)VarcharType.createVarcharType((int)13)).stream().collect(ImmutableMap.toImmutableMap(Type::getTypeSignature, Function.identity())), (Set)(depth == 0 ? ImmutableSet.of() : ImmutableSet.of((Object)TestResolvedFunction.createResolvedFunction("left", depth - 1), (Object)TestResolvedFunction.createResolvedFunction("right", depth - 1))));
    }

    private static Type varcharTypeLoader(TypeId typeId) {
        Matcher matcher = VARCHAR_MATCHER.matcher(typeId.getId());
        boolean matches = matcher.matches();
        Assert.assertTrue((boolean)matches);
        return VarcharType.createVarcharType((int)Integer.parseInt(matcher.group(1)));
    }
}

