/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.policy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.StatsAndCosts;
import io.trino.metadata.TableHandle;
import io.trino.operator.RetryPolicy;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class PlanUtils {
    private PlanUtils() {
    }

    static PlanFragment createAggregationFragment(String name, PlanFragment sourceFragment) {
        RemoteSourceNode source = new RemoteSourceNode(new PlanNodeId("source_id"), sourceFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.NONE);
        AggregationNode planNode = new AggregationNode(new PlanNodeId(name + "_id"), (PlanNode)source, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)ImmutableList.of()), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
        return PlanUtils.createFragment((PlanNode)planNode);
    }

    static PlanFragment createBroadcastJoinPlanFragment(String name, PlanFragment buildFragment) {
        Symbol symbol = new Symbol("column");
        TableScanNode tableScan = TableScanNode.newInstance((PlanNodeId)new PlanNodeId(name), (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false, Optional.empty());
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("build_id"), buildFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPLICATE, RetryPolicy.NONE);
        JoinNode join = new JoinNode(new PlanNodeId(name + "_id"), JoinNode.Type.INNER, (PlanNode)tableScan, (PlanNode)remote, (List)ImmutableList.of(), tableScan.getOutputSymbols(), remote.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        return PlanUtils.createFragment((PlanNode)join);
    }

    static PlanFragment createJoinPlanFragment(JoinNode.Type joinType, String name, PlanFragment buildFragment, PlanFragment probeFragment) {
        return PlanUtils.createJoinPlanFragment(joinType, JoinNode.DistributionType.PARTITIONED, name, buildFragment, probeFragment);
    }

    static PlanFragment createJoinPlanFragment(JoinNode.Type joinType, JoinNode.DistributionType distributionType, String name, PlanFragment buildFragment, PlanFragment probeFragment) {
        RemoteSourceNode probe = new RemoteSourceNode(new PlanNodeId("probe_id"), probeFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.NONE);
        RemoteSourceNode build = new RemoteSourceNode(new PlanNodeId("build_id"), buildFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.NONE);
        JoinNode planNode = new JoinNode(new PlanNodeId(name + "_id"), joinType, (PlanNode)probe, (PlanNode)build, (List)ImmutableList.of(), probe.getOutputSymbols(), build.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(distributionType), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        return PlanUtils.createFragment((PlanNode)planNode);
    }

    static PlanFragment createBroadcastAndPartitionedJoinPlanFragment(String name, PlanFragment broadcastBuildFragment, PlanFragment partitionedBuildFragment, PlanFragment probeFragment) {
        RemoteSourceNode probe = new RemoteSourceNode(new PlanNodeId("probe_id"), probeFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.NONE);
        RemoteSourceNode broadcastBuild = new RemoteSourceNode(new PlanNodeId("broadcast_build_id"), broadcastBuildFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPLICATE, RetryPolicy.NONE);
        RemoteSourceNode partitionedBuild = new RemoteSourceNode(new PlanNodeId("partitioned_build_id"), partitionedBuildFragment.getId(), (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.NONE);
        JoinNode broadcastPlanNode = new JoinNode(new PlanNodeId(name + "_broadcast_id"), JoinNode.Type.INNER, (PlanNode)probe, (PlanNode)broadcastBuild, (List)ImmutableList.of(), probe.getOutputSymbols(), broadcastBuild.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        JoinNode partitionedPlanNode = new JoinNode(new PlanNodeId(name + "_partitioned_id"), JoinNode.Type.INNER, (PlanNode)broadcastPlanNode, (PlanNode)partitionedBuild, (List)ImmutableList.of(), broadcastPlanNode.getOutputSymbols(), partitionedBuild.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        return PlanUtils.createFragment((PlanNode)partitionedPlanNode);
    }

    static PlanFragment createTableScanPlanFragment(String name) {
        Symbol symbol = new Symbol("column");
        TableScanNode planNode = TableScanNode.newInstance((PlanNodeId)new PlanNodeId(name), (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false, Optional.empty());
        return PlanUtils.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createFragment(PlanNode planNode) {
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (Symbol symbol : planNode.getOutputSymbols()) {
            types.put((Object)symbol, (Object)VarcharType.VARCHAR);
        }
        return new PlanFragment(new PlanFragmentId(planNode.getId() + "_fragment_id"), planNode, (Map)types.buildOrThrow(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)planNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), planNode.getOutputSymbols()), StatsAndCosts.empty(), (List)ImmutableList.of(), Optional.empty());
    }
}

