/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.trino.execution.buffer.SpoolingOutputStats;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSpoolingOutputStats {
    private static final double EXPECTED_PRECISION_LOSS_IN_PERCENTS = 0.390625;

    @Test
    public void test() {
        int numberOfPartitions = 15;
        SpoolingOutputStats spoolingOutputStats = new SpoolingOutputStats(numberOfPartitions);
        Assertions.assertThat((Optional)spoolingOutputStats.getFinalSnapshot()).isEmpty();
        long[] expectedValues = new long[numberOfPartitions];
        long value = 1L;
        for (int partition = 0; partition < numberOfPartitions; ++partition) {
            spoolingOutputStats.update(partition, value);
            expectedValues[partition] = value;
            value *= 31L;
        }
        Assertions.assertThat((Optional)spoolingOutputStats.getFinalSnapshot()).isEmpty();
        spoolingOutputStats.finish();
        Assertions.assertThat((Optional)spoolingOutputStats.getFinalSnapshot()).isPresent();
        spoolingOutputStats.update(0, value);
        spoolingOutputStats.finish();
        Assertions.assertThat((Optional)spoolingOutputStats.getFinalSnapshot()).isPresent();
        SpoolingOutputStats.Snapshot snapshot = (SpoolingOutputStats.Snapshot)spoolingOutputStats.getFinalSnapshot().orElseThrow();
        Assert.assertEquals((long)snapshot.getPartitionSizeInBytes(0), (long)1L);
        for (int partition = 0; partition < numberOfPartitions; ++partition) {
            Assertions.assertThat((long)snapshot.getPartitionSizeInBytes(partition)).isCloseTo(expectedValues[partition], Percentage.withPercentage((double)0.390625));
        }
    }
}

