/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemGenerator;
import io.trino.type.InternalTypeManager;
import io.trino.util.Ciphers;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPagesSerde {
    private BlockEncodingSerde blockEncodingSerde;

    @BeforeClass
    public void setup() {
        this.blockEncodingSerde = new InternalBlockEncodingSerde(new BlockEncodingManager(), InternalTypeManager.TESTING_TYPE_MANAGER);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.blockEncodingSerde = null;
    }

    @Test
    public void testRoundTrip() {
        this.testRoundTrip((List<Type>)ImmutableList.of(), 0);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 0);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 1);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 1);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 1);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 30);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 20);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 15);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 300);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 200);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 150);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 300);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 200);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), 150);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 3000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 2000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), 1500);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 12000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 9000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), 8000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 30000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 20000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), 15000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 120000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), 90000);
        this.testRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), 80000);
    }

    private void testRoundTrip(List<Type> types, int rowCount) {
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        int pageCount = 3;
        List pages = (List)IntStream.range(0, pageCount).mapToObj(i -> TestPagesSerde.generatePage(types, rowCount, iterator)).collect(ImmutableList.toImmutableList());
        this.testRoundTrip(types, pages);
    }

    private void testRoundTrip(List<Type> types, List<Page> pages) {
        this.testRoundTrip(types, pages, 107);
        this.testRoundTrip(types, pages, 1009);
        this.testRoundTrip(types, pages, 65536);
        this.testRoundTrip(types, pages, 131072);
    }

    private void testRoundTrip(List<Type> types, List<Page> pages, int blockSizeInBytes) {
        this.testRoundTrip(types, pages, false, false, blockSizeInBytes);
        this.testRoundTrip(types, pages, true, false, blockSizeInBytes);
        this.testRoundTrip(types, pages, false, true, blockSizeInBytes);
        this.testRoundTrip(types, pages, true, true, blockSizeInBytes);
    }

    private void testRoundTrip(List<Type> types, List<Page> pages, boolean compressionEnabled, boolean encryptionEnabled, int blockSizeInBytes) {
        Optional<Object> encryptionKey = encryptionEnabled ? Optional.of(Ciphers.createRandomAesEncryptionKey()) : Optional.empty();
        PageSerializer serializer = new PageSerializer(this.blockEncodingSerde, compressionEnabled, encryptionKey, blockSizeInBytes);
        PageDeserializer deserializer = new PageDeserializer(this.blockEncodingSerde, compressionEnabled, encryptionKey, blockSizeInBytes);
        for (Page page : pages) {
            Slice serialized = serializer.serialize(page);
            Page deserialized = deserializer.deserialize(serialized);
            PageAssertions.assertPageEquals(types, deserialized, page);
        }
    }

    private static Page generatePage(List<Type> types, int rowCount, Iterator<LineItem> iterator) {
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int row = 0; row < rowCount; ++row) {
            pageBuilder.declarePosition();
            LineItem lineItem = iterator.next();
            for (int column = 0; column < types.size(); ++column) {
                Type type = types.get(column);
                if (BigintType.BIGINT.equals((Object)type)) {
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(column), lineItem.getOrderKey());
                    continue;
                }
                if (VarcharType.VARCHAR.equals((Object)type)) {
                    VarcharType.VARCHAR.writeString(pageBuilder.getBlockBuilder(column), lineItem.getComment());
                    continue;
                }
                if (!DoubleType.DOUBLE.equals((Object)type)) continue;
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(column), lineItem.getExtendedPrice());
            }
        }
        return pageBuilder.build();
    }

    @Test
    public void testBigintSerializedSize() {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 5);
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = this.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page);
        Assert.assertEquals((int)pageSize, (int)40);
        BigintType.BIGINT.writeLong(builder, 123L);
        pageSize = 35;
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = this.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)9);
        BigintType.BIGINT.writeLong(builder, 456L);
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = this.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)8);
    }

    @Test
    public void testVarcharSerializedSize() {
        VariableWidthBlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = this.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page);
        Assert.assertEquals((int)pageSize, (int)48);
        VarcharType.VARCHAR.writeString((BlockBuilder)builder, "alice");
        pageSize = 44;
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = this.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)13);
        VarcharType.VARCHAR.writeString((BlockBuilder)builder, "bob");
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = this.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)7);
    }

    private int serializedSize(List<? extends Type> types, Page expectedPage) {
        PagesSerdeFactory serdeFactory = new PagesSerdeFactory(this.blockEncodingSerde, false);
        PageSerializer serializer = serdeFactory.createSerializer(Optional.empty());
        PageDeserializer deserializer = serdeFactory.createDeserializer(Optional.empty());
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        PagesSerdeUtil.writePages((PageSerializer)serializer, (SliceOutput)sliceOutput, (Page[])new Page[]{expectedPage});
        Slice slice = sliceOutput.slice();
        Iterator pageIterator = PagesSerdeUtil.readPages((PageDeserializer)deserializer, (InputStream)slice.getInput());
        if (pageIterator.hasNext()) {
            PageAssertions.assertPageEquals(types, (Page)pageIterator.next(), expectedPage);
        } else {
            Assert.assertEquals((int)expectedPage.getPositionCount(), (int)0);
        }
        Assert.assertFalse((boolean)pageIterator.hasNext());
        return slice.length();
    }

    @Test
    public void testDeserializationWithRollover() {
        for (int blockSize = 100; blockSize < 500; blockSize += 101) {
            for (int numberOfEntries = 500; numberOfEntries < 1000; numberOfEntries += 99) {
                this.testDeserializationWithRollover(blockSize, numberOfEntries);
            }
        }
    }

    private void testDeserializationWithRollover(int blockSize, int numberOfEntries) {
        this.testDeserializationWithRollover(false, false, numberOfEntries, blockSize);
        this.testDeserializationWithRollover(false, true, numberOfEntries, blockSize);
        this.testDeserializationWithRollover(true, false, numberOfEntries, blockSize);
        this.testDeserializationWithRollover(true, true, numberOfEntries, blockSize);
    }

    private void testDeserializationWithRollover(boolean encryptionEnabled, boolean compressionEnabled, int numberOfEntries, int blockSize) {
        RolloverBlockSerde blockSerde = new RolloverBlockSerde();
        Optional<Object> encryptionKey = encryptionEnabled ? Optional.of(Ciphers.createRandomAesEncryptionKey()) : Optional.empty();
        PageSerializer serializer = new PageSerializer((BlockEncodingSerde)blockSerde, compressionEnabled, encryptionKey, blockSize);
        PageDeserializer deserializer = new PageDeserializer((BlockEncodingSerde)blockSerde, compressionEnabled, encryptionKey, blockSize);
        Page page = TestPagesSerde.createTestPage(numberOfEntries);
        Slice serialized = serializer.serialize(page);
        Page deserialized = deserializer.deserialize(serialized);
        Assert.assertEquals((int)deserialized.getChannelCount(), (int)1);
        VariableWidthBlock expected = (VariableWidthBlock)page.getBlock(0);
        VariableWidthBlock actual = (VariableWidthBlock)deserialized.getBlock(0);
        Assertions.assertThat((byte[])actual.getRawSlice().getBytes()).isEqualTo((Object)expected.getRawSlice().getBytes());
    }

    private static Page createTestPage(int numberOfEntries) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 1000);
        blockBuilder.buildEntry(value -> {
            value.writeInt(numberOfEntries);
            for (int i = 0; i < numberOfEntries; ++i) {
                value.writeLong((long)i);
            }
        });
        return new Page(new Block[]{blockBuilder.build()});
    }

    private static class RolloverBlockSerde
    implements BlockEncodingSerde {
        private RolloverBlockSerde() {
        }

        public Block readBlock(SliceInput input) {
            int numberOfEntries = input.readInt();
            VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, 1000);
            blockBuilder.buildEntry(value -> {
                value.writeInt(numberOfEntries);
                for (int i = 0; i < numberOfEntries; ++i) {
                    value.writeLong(input.readLong());
                }
            });
            return blockBuilder.build();
        }

        public void writeBlock(SliceOutput output, Block block) {
            int offset = 0;
            int numberOfEntries = block.getInt(0, offset);
            output.writeInt(numberOfEntries);
            offset += 4;
            for (int i = 0; i < numberOfEntries; ++i) {
                long value = block.getLong(0, offset);
                offset += 8;
                long b7 = value >> 56 & 0xFFL;
                long b6 = value >> 48 & 0xFFL;
                long b5 = value >> 40 & 0xFFL;
                long b4 = value >> 32 & 0xFFL;
                long b3 = value >> 24 & 0xFFL;
                long b2 = value >> 16 & 0xFFL;
                long b1 = value >> 8 & 0xFFL;
                long b0 = value & 0xFFL;
                output.writeByte((int)b0);
                output.writeByte((int)b1);
                output.writeByte((int)b2);
                output.writeByte((int)b3);
                output.writeByte((int)b4);
                output.writeByte((int)b5);
                output.writeByte((int)b6);
                output.writeByte((int)b7);
            }
        }

        public Type readType(SliceInput sliceInput) {
            throw new RuntimeException("not implemented");
        }

        public void writeType(SliceOutput sliceOutput, Type type) {
            throw new RuntimeException("not implemented");
        }
    }
}

