/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.DropMaterializedViewTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDropMaterializedViewTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testDropExistingMaterializedView() {
        QualifiedObjectName viewName = TestDropMaterializedViewTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, viewName, this.someMaterializedView(), false, false);
        Assertions.assertThat((boolean)this.metadata.isMaterializedView(this.testSession, viewName)).isTrue();
        MoreFutures.getFutureValue(this.executeDropMaterializedView(TestDropMaterializedViewTask.asQualifiedName(viewName), false));
        Assertions.assertThat((boolean)this.metadata.isMaterializedView(this.testSession, viewName)).isFalse();
    }

    @Test
    public void testDropNotExistingMaterializedView() {
        QualifiedName viewName = TestDropMaterializedViewTask.qualifiedName("not_existing_materialized_view");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropMaterializedView(viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Materialized view '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testDropNotExistingMaterializedViewIfExists() {
        QualifiedName viewName = TestDropMaterializedViewTask.qualifiedName("not_existing_materialized_view");
        MoreFutures.getFutureValue(this.executeDropMaterializedView(viewName, true));
    }

    @Test
    public void testDropMaterializedViewOnTable() {
        QualifiedObjectName tableName = TestDropMaterializedViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropMaterializedViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropMaterializedView(TestDropMaterializedViewTask.asQualifiedName(tableName), true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Materialized view '%s' does not exist, but a table with that name exists. Did you mean DROP TABLE %s?", new Object[]{tableName, tableName});
    }

    @Test
    public void testDropMaterializedViewOnTableIfExists() {
        QualifiedObjectName tableName = TestDropMaterializedViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestDropMaterializedViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropMaterializedView(TestDropMaterializedViewTask.asQualifiedName(tableName), true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Materialized view '%s' does not exist, but a table with that name exists. Did you mean DROP TABLE %s?", new Object[]{tableName, tableName});
    }

    @Test
    public void testDropMaterializedViewOnView() {
        QualifiedName viewName = TestDropMaterializedViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, TestDropMaterializedViewTask.asQualifiedObjectName(viewName), TestDropMaterializedViewTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropMaterializedView(viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Materialized view '%s' does not exist, but a view with that name exists. Did you mean DROP VIEW %s?", new Object[]{viewName, viewName});
    }

    @Test
    public void testDropMaterializedViewOnViewIfExists() {
        QualifiedName viewName = TestDropMaterializedViewTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, TestDropMaterializedViewTask.asQualifiedObjectName(viewName), TestDropMaterializedViewTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropMaterializedView(viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Materialized view '%s' does not exist, but a view with that name exists. Did you mean DROP VIEW %s?", new Object[]{viewName, viewName});
    }

    private ListenableFuture<Void> executeDropMaterializedView(QualifiedName viewName, boolean exists) {
        return new DropMaterializedViewTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(new DropMaterializedView(viewName, exists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

