/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsCalculatorAssertion;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.function.Function;

public class StatsCalculatorTester
implements AutoCloseable {
    private final StatsCalculator statsCalculator;
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;

    public StatsCalculatorTester() {
        this(TestingSession.testSessionBuilder().build());
    }

    public StatsCalculatorTester(Session session) {
        this(StatsCalculatorTester.createQueryRunner(session));
    }

    private StatsCalculatorTester(LocalQueryRunner queryRunner) {
        this.statsCalculator = queryRunner.getStatsCalculator();
        this.session = queryRunner.getDefaultSession();
        this.metadata = queryRunner.getMetadata();
        this.queryRunner = queryRunner;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private static LocalQueryRunner createQueryRunner(Session session) {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)session);
        queryRunner.createCatalog((String)session.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    public StatsCalculatorAssertion assertStatsFor(Function<PlanBuilder, PlanNode> planProvider) {
        return this.assertStatsFor(this.session, planProvider);
    }

    public StatsCalculatorAssertion assertStatsFor(Session session, Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.metadata, session);
        PlanNode planNode = planProvider.apply(planBuilder);
        return new StatsCalculatorAssertion(this.metadata, this.statsCalculator, session, planNode, planBuilder.getTypes());
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }
}

