/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;

public class MockConnectorPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final Metrics metrics;

    public MockConnectorPageSource(ConnectorPageSource delegate, Metrics metrics) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.metrics = Objects.requireNonNull(metrics, "metrics is null");
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        return this.delegate.getNextPage();
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public CompletableFuture<?> isBlocked() {
        return this.delegate.isBlocked();
    }

    public Metrics getMetrics() {
        return this.delegate.getMetrics().mergeWith(this.metrics);
    }
}

