/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.ColumnarTestUtils;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnarArray {
    private static final int[] ARRAY_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void test() {
        Slice[][] expectedValues = new Slice[ARRAY_SIZES.length][];
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = new Slice[ARRAY_SIZES[i]];
            for (int j = 0; j < ARRAY_SIZES[i]; ++j) {
                if (j % 3 == 1) continue;
                expectedValues[i][j] = Slices.utf8Slice((String)String.format("%d.%d", i, j));
            }
        }
        BlockBuilder blockBuilder = TestColumnarArray.createBlockBuilderWithValues(expectedValues);
        TestColumnarArray.verifyBlock((Block)blockBuilder, expectedValues);
        TestColumnarArray.verifyBlock(blockBuilder.build(), expectedValues);
        Slice[][] expectedValuesWithNull = (Slice[][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestColumnarArray.createBlockBuilderWithValues(expectedValuesWithNull);
        TestColumnarArray.verifyBlock((Block)blockBuilderWithNull, expectedValuesWithNull);
        TestColumnarArray.verifyBlock(blockBuilderWithNull.build(), expectedValuesWithNull);
    }

    private static <T> void verifyBlock(Block block, T[] expectedValues) {
        ColumnarTestUtils.assertBlock(block, expectedValues);
        TestColumnarArray.assertColumnarArray(block, expectedValues);
        TestColumnarArray.assertDictionaryBlock(block, expectedValues);
        TestColumnarArray.assertRunLengthEncodedBlock(block, expectedValues);
        int offset = 1;
        int length = expectedValues.length - 2;
        Block blockRegion = block.getRegion(offset, length);
        T[] expectedValuesRegion = Arrays.copyOfRange(expectedValues, offset, offset + length);
        ColumnarTestUtils.assertBlock(blockRegion, expectedValuesRegion);
        TestColumnarArray.assertColumnarArray(blockRegion, expectedValuesRegion);
        TestColumnarArray.assertDictionaryBlock(blockRegion, expectedValuesRegion);
        TestColumnarArray.assertRunLengthEncodedBlock(blockRegion, expectedValuesRegion);
    }

    private static <T> void assertDictionaryBlock(Block block, T[] expectedValues) {
        Block dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        T[] expectedDictionaryValues = ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock(dictionaryBlock, expectedDictionaryValues);
        TestColumnarArray.assertColumnarArray(dictionaryBlock, expectedDictionaryValues);
        TestColumnarArray.assertRunLengthEncodedBlock(dictionaryBlock, expectedDictionaryValues);
    }

    private static <T> void assertRunLengthEncodedBlock(Block block, T[] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            T[] expectedDictionaryValues = ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestColumnarArray.assertColumnarArray((Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static <T> void assertColumnarArray(Block block, T[] expectedValues) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
        Assert.assertEquals((int)columnarArray.getPositionCount(), (int)expectedValues.length);
        Block elementsBlock = columnarArray.getElementsBlock();
        int elementsPosition = 0;
        for (int position = 0; position < expectedValues.length; ++position) {
            T expectedArray = expectedValues[position];
            Assert.assertEquals((boolean)columnarArray.isNull(position), (expectedArray == null ? 1 : 0) != 0);
            Assert.assertEquals((int)columnarArray.getLength(position), (int)(expectedArray == null ? 0 : Array.getLength(expectedArray)));
            Assert.assertEquals((int)elementsPosition, (int)columnarArray.getOffset(position));
            for (int i = 0; i < columnarArray.getLength(position); ++i) {
                Object expectedElement = Array.get(expectedArray, i);
                ColumnarTestUtils.assertBlockPosition(elementsBlock, elementsPosition, expectedElement);
                ++elementsPosition;
            }
        }
    }

    public static BlockBuilder createBlockBuilderWithValues(Slice[][] expectedValues) {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 100, 100);
        for (Slice[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            VariableWidthBlockBuilder elementBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, expectedValue.length);
            for (Slice v : expectedValue) {
                if (v == null) {
                    elementBlockBuilder.appendNull();
                    continue;
                }
                VarcharType.VARCHAR.writeSlice((BlockBuilder)elementBlockBuilder, v);
            }
            arrayType.writeObject((BlockBuilder)blockBuilder, (Object)elementBlockBuilder.build());
        }
        return blockBuilder;
    }
}

