/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.trino.jmh.Benchmarks;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.StructuralTestUtil;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10)
@Fork(value=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapCopy {
    private static final int POSITIONS = 100000;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public BlockBuilder benchmarkMapCopy(BenchmarkData data) {
        Block block = data.getDataBlock();
        BlockBuilder blockBuilder = data.getBlockBuilder();
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        for (int i = 0; i < 100000; ++i) {
            mapType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder;
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkMapCopy().benchmarkMapCopy(data);
        Benchmarks.benchmark(BenchmarkMapCopy.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "2", "4", "8", "16"})
        private int mapSize;
        private Block dataBlock;
        private MapBlockBuilder blockBuilder;

        @Setup
        public void setup() {
            MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
            this.blockBuilder = mapType.createBlockBuilder(null, 100000);
            for (int position = 0; position < 100000; ++position) {
                this.blockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
                    for (int i = 0; i < this.mapSize; ++i) {
                        VarcharType.VARCHAR.writeString(keyBuilder, String.valueOf(ThreadLocalRandom.current().nextInt()));
                        BigintType.BIGINT.writeLong(valueBuilder, (long)ThreadLocalRandom.current().nextInt());
                    }
                });
            }
            this.dataBlock = this.blockBuilder.build();
        }

        public Block getDataBlock() {
            return this.dataBlock;
        }

        public BlockBuilder getBlockBuilder() {
            return this.blockBuilder.newBlockBuilderLike(null);
        }
    }
}

