/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import io.trino.Session;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSession {
    @Test
    public void testSetCatalogProperty() {
        Session session = Session.builder((Session)TestingSession.testSessionBuilder().build()).setCatalogSessionProperty("some_catalog", "first_property", "some_value").build();
        Assertions.assertThat((Map)session.getCatalogProperties()).isEqualTo(Map.of("some_catalog", Map.of("first_property", "some_value")));
    }

    @Test
    public void testBuildWithCatalogProperty() {
        Session session = Session.builder((Session)TestingSession.testSessionBuilder().build()).setCatalogSessionProperty("some_catalog", "first_property", "some_value").build();
        session = Session.builder((Session)session).build();
        Assertions.assertThat((Map)session.getCatalogProperties()).isEqualTo(Map.of("some_catalog", Map.of("first_property", "some_value")));
    }

    @Test
    public void testAddSecondCatalogProperty() {
        Session session = Session.builder((Session)TestingSession.testSessionBuilder().build()).setCatalogSessionProperty("some_catalog", "first_property", "some_value").build();
        session = Session.builder((Session)session).setCatalogSessionProperty("some_catalog", "second_property", "another_value").build();
        Assertions.assertThat((Map)session.getCatalogProperties()).isEqualTo(Map.of("some_catalog", Map.of("first_property", "some_value", "second_property", "another_value")));
    }
}

