/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestHiddenColumns {
    private LocalQueryRunner runner;
    private QueryAssertions assertions;

    @BeforeAll
    public void setUp() {
        this.runner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        this.runner.createCatalog((String)SessionTestUtils.TEST_SESSION.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)this.runner);
    }

    @AfterAll
    public void destroy() {
        if (this.runner != null) {
            this.runner.close();
            this.runner = null;
            this.assertions = null;
        }
    }

    @Test
    public void testDescribeTable() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("DESCRIBE region")))).matches(MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"regionkey", "bigint", "", ""}).row(new Object[]{"name", "varchar(25)", "", ""}).row(new Object[]{"comment", "varchar(152)", "", ""}).build());
    }

    @Test
    public void testSimpleSelect() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM region")))).matches("SELECT regionkey, name, comment FROM region");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT *, row_number FROM region")))).matches("SELECT regionkey, name, comment, row_number FROM region");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT row_number, * FROM region")))).matches("SELECT row_number, regionkey, name, comment FROM region");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT *, row_number, * FROM region")))).matches("SELECT regionkey, name, comment, row_number, regionkey, name, comment FROM region");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT row_number, x.row_number FROM region x")))).matches("SELECT row_number, row_number FROM region");
    }

    @Test
    public void testAliasedTableColumns() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM orders AS t (a, b, c, d, e, f, g, h, i)")))).matches("SELECT * FROM orders");
    }
}

