/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.ForwardedHeaderParser;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;

final class ClientAddressAndPortExtractor<REQUEST>
implements FallbackAddressPortExtractor<REQUEST> {
    private final HttpServerAttributesGetter<REQUEST, ?> getter;

    ClientAddressAndPortExtractor(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(FallbackAddressPortExtractor.AddressPortSink sink2, REQUEST request) {
        String forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractClientIpFromForwardedHeader(forwarded)) != null) {
            sink2.setAddress(forwarded);
            return;
        }
        forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "x-forwarded-for"));
        if (forwarded != null) {
            sink2.setAddress(ForwardedHeaderParser.extractClientIpFromForwardedForHeader(forwarded));
        }
    }
}

