/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.pool.MetricsAwareExecutorService;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.util.GridMutableLong;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.Nullable;

public class IgniteThreadPoolExecutor
extends ThreadPoolExecutor
implements MetricsAwareExecutorService {
    @GridToStringExclude
    private final ThreadLocal<GridMutableLong> taskStartTime = ThreadLocal.withInitial(() -> new GridMutableLong(0L));
    @GridToStringExclude
    private volatile HistogramMetricImpl execTime;

    public IgniteThreadPoolExecutor(String threadNamePrefix, String igniteInstanceName, int corePoolSize, int maxPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQ) {
        this(threadNamePrefix, igniteInstanceName, corePoolSize, maxPoolSize, keepAliveTime, workQ, -1, null);
    }

    public IgniteThreadPoolExecutor(String threadNamePrefix, String igniteInstanceName, int corePoolSize, int maxPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQ, byte plc, Thread.UncaughtExceptionHandler eHnd) {
        this(corePoolSize, maxPoolSize, keepAliveTime, workQ, new IgniteThreadFactory(igniteInstanceName, threadNamePrefix, plc, eHnd));
    }

    public IgniteThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQ, ThreadFactory threadFactory) {
        this(corePoolSize, maxPoolSize, keepAliveTime, workQ, threadFactory, null);
    }

    protected IgniteThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQ, ThreadFactory threadFactory, @Nullable HistogramMetricImpl execTime) {
        super(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, workQ, threadFactory, new ThreadPoolExecutor.AbortPolicy());
        this.execTime = execTime != null ? execTime : new HistogramMetricImpl("TaskExecutionTime", "Tasks execution times as histogram (milliseconds).", PoolProcessor.TASK_EXEC_TIME_HISTOGRAM_BUCKETS);
    }

    @Override
    protected void beforeExecute(Thread t2, Runnable r) {
        super.beforeExecute(t2, r);
        this.taskStartTime.get().set(U.currentTimeMillis());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t2) {
        GridMutableLong val = this.taskStartTime.get();
        this.execTime.value(U.currentTimeMillis() - val.get());
        super.afterExecute(r, t2);
    }

    @Override
    public void registerMetrics(MetricRegistry mreg) {
        mreg.register("ActiveCount", this::getActiveCount, "Approximate number of threads that are actively executing tasks.");
        mreg.register("CompletedTaskCount", this::getCompletedTaskCount, "Approximate total number of tasks that have completed execution.");
        mreg.register("CorePoolSize", this::getCorePoolSize, "The core number of threads.");
        mreg.register("LargestPoolSize", this::getLargestPoolSize, "Largest number of threads that have ever simultaneously been in the pool.");
        mreg.register("MaximumPoolSize", this::getMaximumPoolSize, "The maximum allowed number of threads.");
        mreg.register("PoolSize", this::getPoolSize, "Current number of threads in the pool.");
        mreg.register("TaskCount", this::getTaskCount, "Approximate total number of tasks that have been scheduled for execution.");
        mreg.register("QueueSize", () -> this.getQueue().size(), "Current size of the execution queue.");
        mreg.register("KeepAliveTime", () -> this.getKeepAliveTime(TimeUnit.MILLISECONDS), "Thread keep-alive time, which is the amount of time which threads in excess of the core pool size may remain idle before being terminated.");
        mreg.register("Shutdown", this::isShutdown, "True if this executor has been shut down.");
        mreg.register("Terminated", this::isTerminated, "True if all tasks have completed following shut down.");
        mreg.register("Terminating", this::isTerminating, "True if terminating but not yet terminated.");
        mreg.register("RejectedExecutionHandlerClass", () -> this.getRejectedExecutionHandler().getClass().getName(), String.class, "Class name of current rejection handler.");
        mreg.register("ThreadFactoryClass", () -> this.getThreadFactory().getClass().getName(), String.class, "Class name of thread factory used to create new threads.");
        HistogramMetricImpl execTime0 = this.execTime;
        this.execTime = new HistogramMetricImpl(MetricUtils.metricName(mreg.name(), "TaskExecutionTime"), execTime0);
        mreg.register(this.execTime);
    }

    protected void executionTimeMetric(HistogramMetricImpl execTime) {
        this.execTime = execTime;
    }
}

