/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller.jdk;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.io.GridByteArrayInputStream;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.AbstractNodeNameAwareMarshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshallerInputStreamWrapper;
import org.apache.ignite.marshaller.jdk.JdkMarshallerObjectInputStream;
import org.apache.ignite.marshaller.jdk.JdkMarshallerObjectOutputStream;
import org.apache.ignite.marshaller.jdk.JdkMarshallerOutputStreamWrapper;
import org.jetbrains.annotations.Nullable;

public class JdkMarshaller
extends AbstractNodeNameAwareMarshaller {
    public static final JdkMarshaller DEFAULT = new JdkMarshaller();
    private final IgnitePredicate<String> clsFilter;

    public JdkMarshaller() {
        this(null);
    }

    public JdkMarshaller(IgnitePredicate<String> clsFilter) {
        this.clsFilter = clsFilter;
    }

    @Override
    protected void marshal0(@Nullable Object obj, OutputStream out) throws IgniteCheckedException {
        assert (out != null);
        try (JdkMarshallerObjectOutputStream objOut = new JdkMarshallerObjectOutputStream(new JdkMarshallerOutputStreamWrapper(out));){
            objOut.writeObject(obj);
            objOut.flush();
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to serialize object: " + obj, e);
        }
    }

    @Override
    protected byte[] marshal0(@Nullable Object obj) throws IgniteCheckedException {
        try (GridByteArrayOutputStream out = new GridByteArrayOutputStream(512);){
            this.marshal0(obj, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T unmarshal0(InputStream in, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (in != null);
        if (clsLdr == null) {
            clsLdr = this.getClass().getClassLoader();
        }
        try (JdkMarshallerObjectInputStream objIn = new JdkMarshallerObjectInputStream(new JdkMarshallerInputStreamWrapper(in), clsLdr, this.clsFilter);){
            Object object = objIn.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new IgniteCheckedException("Failed to find class with given class loader for unmarshalling (make sure same versions of all classes are available on all nodes or enable peer-class-loading) [clsLdr=" + clsLdr + ", cls=" + e.getMessage() + "]", e);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to deserialize object with given class loader: " + clsLdr, e);
        }
    }

    @Override
    protected <T> T unmarshal0(byte[] arr, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        try (GridByteArrayInputStream in = new GridByteArrayInputStream(arr, 0, arr.length);){
            T t2 = this.unmarshal0(in, clsLdr);
            return t2;
        }
    }

    @Override
    public void onUndeploy(ClassLoader ldr) {
    }

    public String toString() {
        return S.toString(JdkMarshaller.class, this);
    }
}

