/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.ClassSet;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.marshaller.AbstractNodeNameAwareMarshaller;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;

public class MarshallerUtils {
    public static final String JDK_CLS_NAMES_FILE = "META-INF/classnames-jdk.properties";
    public static final String CLS_NAMES_FILE = "META-INF/classnames.properties";
    private static final ThreadLocal<IgniteProductVersion> JOB_SND_NODE_VER = new ThreadLocal();
    private static final ThreadLocal<IgniteProductVersion> JOB_RCV_NODE_VER = new ThreadLocal();

    public static void setNodeName(Marshaller marsh, @Nullable String nodeName) {
        if (marsh instanceof AbstractNodeNameAwareMarshaller) {
            ((AbstractNodeNameAwareMarshaller)marsh).nodeName(nodeName);
        }
    }

    public static JdkMarshaller jdkMarshaller(@Nullable String nodeName) {
        JdkMarshaller marsh = new JdkMarshaller();
        MarshallerUtils.setNodeName(marsh, nodeName);
        return marsh;
    }

    private MarshallerUtils() {
    }

    public static void jobSenderVersion(IgniteProductVersion ver) {
        JOB_SND_NODE_VER.set(ver);
    }

    public static IgniteProductVersion jobSenderVersion() {
        return JOB_SND_NODE_VER.get();
    }

    public static void jobReceiverVersion(IgniteProductVersion ver) {
        JOB_RCV_NODE_VER.set(ver);
    }

    public static IgniteProductVersion jobReceiverVersion() {
        return JOB_RCV_NODE_VER.get();
    }

    public static IgnitePredicate<String> classNameFilter(ClassLoader clsLdr) throws IgniteCheckedException {
        final ClassSet whiteList = MarshallerUtils.classWhiteList(clsLdr);
        final ClassSet blackList = MarshallerUtils.classBlackList(clsLdr);
        return new IgnitePredicate<String>(){

            @Override
            public boolean apply(String s2) {
                if ((blackList != null || whiteList != null) && s2.charAt(0) == '[') {
                    if (s2.charAt(1) == 'L' && s2.length() > 2) {
                        s2 = s2.substring(2, s2.length() - 1);
                    } else {
                        return true;
                    }
                }
                return !(blackList != null && blackList.contains(s2) || whiteList != null && !whiteList.contains(s2));
            }
        };
    }

    private static ClassSet classWhiteList(ClassLoader clsLdr) throws IgniteCheckedException {
        ClassSet clsSet = null;
        String fileName = IgniteSystemProperties.getString("IGNITE_MARSHALLER_WHITELIST");
        if (fileName != null) {
            clsSet = new ClassSet();
            MarshallerUtils.addClassNames(JDK_CLS_NAMES_FILE, clsSet, clsLdr);
            MarshallerUtils.addClassNames(CLS_NAMES_FILE, clsSet, clsLdr);
            MarshallerUtils.addClassNames(fileName, clsSet, clsLdr);
        }
        return clsSet;
    }

    private static ClassSet classBlackList(ClassLoader clsLdr) throws IgniteCheckedException {
        ClassSet clsSet = null;
        String blackListFileName = IgniteSystemProperties.getString("IGNITE_MARSHALLER_BLACKLIST");
        if (blackListFileName != null) {
            clsSet = new ClassSet();
            MarshallerUtils.addClassNames(blackListFileName, clsSet, clsLdr);
        }
        return clsSet;
    }

    private static void addClassNames(String fileName, ClassSet clsSet, ClassLoader clsLdr) throws IgniteCheckedException {
        InputStream is = clsLdr.getResourceAsStream(fileName);
        if (is == null) {
            try {
                is = new FileInputStream(new File(fileName));
            }
            catch (FileNotFoundException e) {
                throw new IgniteCheckedException("File " + fileName + " not found.");
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            int i = 1;
            while ((line = reader.readLine()) != null) {
                String s2 = line.trim();
                if (!s2.isEmpty() && s2.charAt(0) != '#' && s2.charAt(0) != '[') {
                    try {
                        clsSet.add(s2);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IgniteCheckedException("Exception occurred while reading list of classes[path=" + fileName + ", row=" + i + ", line=" + s2 + ']', e);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Exception occurred while reading and creating list of classes [path=" + fileName + ']', e);
        }
    }

    public static void processSystemClasses(ClassLoader ldr, @Nullable Collection<PluginProvider> plugins, Consumer<String> proc) throws IOException {
        Enumeration<URL> urls = ldr.getResources(CLS_NAMES_FILE);
        boolean foundClsNames = false;
        while (urls.hasMoreElements()) {
            MarshallerUtils.processResource(urls.nextElement(), proc);
            foundClsNames = true;
        }
        if (!foundClsNames) {
            throw new IgniteException("Failed to load class names properties file packaged with ignite binaries [file=META-INF/classnames.properties, ldr=" + ldr + ']');
        }
        URL jdkClsNames = ldr.getResource(JDK_CLS_NAMES_FILE);
        if (jdkClsNames == null) {
            throw new IgniteException("Failed to load class names properties file packaged with ignite binaries [file=META-INF/classnames-jdk.properties, ldr=" + ldr + ']');
        }
        MarshallerUtils.processResource(jdkClsNames, proc);
        if (plugins != null && !plugins.isEmpty()) {
            for (PluginProvider plugin : plugins) {
                Enumeration<URL> pluginUrls = ldr.getResources("META-INF/" + plugin.name().toLowerCase() + ".classnames.properties");
                while (pluginUrls.hasMoreElements()) {
                    MarshallerUtils.processResource(pluginUrls.nextElement(), proc);
                }
            }
        }
    }

    private static void processResource(URL url, Consumer<String> proc) throws IOException {
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = rdr.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                proc.accept(line.trim());
            }
        }
    }
}

