/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.AbstractMarshaller;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNodeNameAwareMarshaller
extends AbstractMarshaller {
    private volatile boolean nodeNameSet;
    private volatile String nodeName = U.LOC_IGNITE_NAME_EMPTY;

    public void nodeName(@Nullable String nodeName) {
        if (!this.nodeNameSet) {
            this.nodeName = nodeName;
            this.nodeNameSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] marshal(@Nullable Object obj) throws IgniteCheckedException {
        String oldNodeName = IgniteUtils.setCurrentIgniteName(this.nodeName);
        try {
            byte[] byArray = this.marshal0(obj);
            return byArray;
        }
        finally {
            IgniteUtils.restoreOldIgniteName(oldNodeName, this.nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(@Nullable Object obj, OutputStream out) throws IgniteCheckedException {
        String oldNodeName = IgniteUtils.setCurrentIgniteName(this.nodeName);
        try {
            this.marshal0(obj, out);
        }
        finally {
            IgniteUtils.restoreOldIgniteName(oldNodeName, this.nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unmarshal(byte[] arr, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        String oldNodeName = IgniteUtils.setCurrentIgniteName(this.nodeName);
        try {
            T t2 = this.unmarshal0(arr, clsLdr);
            return t2;
        }
        finally {
            IgniteUtils.restoreOldIgniteName(oldNodeName, this.nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unmarshal(InputStream in, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        String oldNodeName = IgniteUtils.setCurrentIgniteName(this.nodeName);
        try {
            T t2 = this.unmarshal0(in, clsLdr);
            return t2;
        }
        finally {
            IgniteUtils.restoreOldIgniteName(oldNodeName, this.nodeName);
        }
    }

    protected abstract void marshal0(@Nullable Object var1, OutputStream var2) throws IgniteCheckedException;

    protected abstract byte[] marshal0(@Nullable Object var1) throws IgniteCheckedException;

    protected abstract <T> T unmarshal0(InputStream var1, @Nullable ClassLoader var2) throws IgniteCheckedException;

    protected abstract <T> T unmarshal0(byte[] var1, @Nullable ClassLoader var2) throws IgniteCheckedException;
}

