/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.logger.IgniteLoggerEx;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.java.JavaLoggerFileHandler;
import org.jetbrains.annotations.Nullable;

public class JavaLogger
implements IgniteLoggerEx {
    public static final String DFLT_CONFIG_PATH = "config/java.util.logging.properties";
    private static final Object mux = new Object();
    private static volatile boolean inited;
    private static volatile boolean quiet0;
    @GridToStringExclude
    private Logger impl;
    @GridToStringExclude
    private String cfg;
    private final boolean quiet;
    @GridToStringExclude
    private volatile String workDir;
    @GridToStringExclude
    private volatile UUID nodeId;

    public JavaLogger() {
        this(!JavaLogger.isConfigured());
    }

    public static boolean isConfigured() {
        return System.getProperty("java.util.logging.config.file") != null;
    }

    private void defaultConfiguration() {
        URL cfgUrl = U.resolveIgniteUrl(DFLT_CONFIG_PATH);
        if (cfgUrl == null) {
            this.warning("Failed to resolve default logging config file: config/java.util.logging.properties");
            return;
        }
        try (InputStream in = cfgUrl.openStream();){
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException e) {
            this.error("Failed to read logging configuration: " + cfgUrl, e);
        }
        this.cfg = cfgUrl.getPath();
    }

    public JavaLogger(boolean init) {
        this.impl = Logger.getLogger("");
        if (init) {
            this.configure(null);
            this.quiet = quiet0;
        } else {
            this.quiet = true;
        }
    }

    public JavaLogger(Logger impl2) {
        this(impl2, true);
    }

    public JavaLogger(Logger impl2, boolean configure) {
        assert (impl2 != null);
        if (configure) {
            this.configure(impl2);
        } else {
            this.impl = impl2;
        }
        this.quiet = quiet0;
    }

    @Override
    public IgniteLogger getLogger(Object ctgr) {
        return new JavaLogger(ctgr == null ? Logger.getLogger("") : Logger.getLogger(ctgr instanceof Class ? ((Class)ctgr).getName() : String.valueOf(ctgr)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(@Nullable Logger initImpl) {
        if (initImpl != null) {
            this.impl = initImpl;
        }
        if (inited) {
            return;
        }
        Object object = mux;
        synchronized (object) {
            if (inited) {
                return;
            }
            if (JavaLogger.isConfigured()) {
                boolean consoleHndFound = JavaLogger.findHandler(this.impl, ConsoleHandler.class) != null;
                quiet0 = !consoleHndFound;
                inited = true;
                this.cfg = System.getProperty("java.util.logging.config.file");
                return;
            }
            this.defaultConfiguration();
            boolean quiet = Boolean.parseBoolean(System.getProperty("IGNITE_QUIET", "true"));
            boolean useConsoleAppender = Boolean.parseBoolean(System.getProperty("IGNITE_CONSOLE_APPENDER", "true"));
            if (useConsoleAppender) {
                ConsoleHandler consoleHnd = JavaLogger.findHandler(this.impl, ConsoleHandler.class);
                if (consoleHnd != null) {
                    consoleHnd.setLevel(quiet ? Level.SEVERE : Level.INFO);
                } else {
                    System.err.println("Console logging handler is not configured.");
                }
            } else {
                Handler[] handlers = Logger.getLogger("").getHandlers();
                if (!F.isEmpty(handlers)) {
                    for (Handler h2 : handlers) {
                        if (!(h2 instanceof ConsoleHandler)) continue;
                        this.impl.removeHandler(h2);
                    }
                }
            }
            quiet0 = quiet;
            inited = true;
        }
    }

    @Override
    public void trace(String msg) {
        if (!this.impl.isLoggable(Level.FINEST)) {
            this.warning("Logging at TRACE level without checking if TRACE level is enabled: " + msg);
        }
        this.impl.finest(msg);
    }

    @Override
    public void debug(String msg) {
        if (!this.impl.isLoggable(Level.FINE)) {
            this.warning("Logging at DEBUG level without checking if DEBUG level is enabled: " + msg);
        }
        this.impl.fine(msg);
    }

    @Override
    public void info(String msg) {
        if (!this.impl.isLoggable(Level.INFO)) {
            this.warning("Logging at INFO level without checking if INFO level is enabled: " + msg);
        }
        this.impl.info(msg);
    }

    @Override
    public void warning(String msg) {
        this.impl.warning(msg);
    }

    @Override
    public void warning(String msg, @Nullable Throwable e) {
        this.impl.log(Level.WARNING, msg, e);
    }

    @Override
    public void error(String msg) {
        this.impl.severe(msg);
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public void error(String msg, @Nullable Throwable e) {
        this.impl.log(Level.SEVERE, msg, e);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.impl.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.impl.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.impl.isLoggable(Level.INFO);
    }

    @Override
    @Nullable
    public String fileName() {
        JavaLoggerFileHandler gridFileHnd = JavaLogger.findHandler(this.impl, JavaLoggerFileHandler.class);
        if (gridFileHnd != null) {
            return gridFileHnd.fileName();
        }
        FileHandler fileHnd = JavaLogger.findHandler(this.impl, FileHandler.class);
        return JavaLogger.fileName(fileHnd);
    }

    @Override
    public void addConsoleAppender(boolean clearOutput) {
        this.impl.addHandler(new StreamHandler(System.out, new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + U.nl();
            }
        }));
    }

    @Override
    public void flush() {
        for (Handler h2 : this.impl.getHandlers()) {
            h2.flush();
        }
    }

    @Nullable
    static String fileName(FileHandler fileHnd) {
        if (fileHnd == null) {
            return null;
        }
        try {
            File[] logFiles = (File[])U.field(fileHnd, "files");
            return logFiles[0].getAbsolutePath();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void setWorkDirectory(String workDir) {
        this.workDir = workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationAndNode(@Nullable String application, @Nullable UUID nodeId) {
        if (this.nodeId != null) {
            return;
        }
        Object object = mux;
        synchronized (object) {
            if (this.nodeId != null) {
                return;
            }
            this.nodeId = nodeId;
        }
        JavaLoggerFileHandler fileHnd = JavaLogger.findHandler(this.impl, JavaLoggerFileHandler.class);
        if (fileHnd == null) {
            return;
        }
        try {
            fileHnd.nodeId(application, nodeId, this.workDir);
        }
        catch (IOException | IgniteCheckedException e) {
            throw new RuntimeException("Failed to enable file handler.", e);
        }
    }

    private static <T> T findHandler(Logger log, Class<T> cls) {
        while (log != null) {
            for (Handler hnd : log.getHandlers()) {
                if (!cls.isInstance(hnd)) continue;
                return (T)hnd;
            }
            log = log.getParent();
        }
        return null;
    }

    public String toString() {
        return S.toString(JavaLogger.class, this, "config", (Object)this.cfg);
    }
}

