/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.snapshot;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotJob;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotOneNodeTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskAction;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskArg;

@GridInternal
public class VisorSnapshotRestoreTask
extends VisorSnapshotOneNodeTask<VisorSnapshotRestoreTaskArg, String> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorSnapshotRestoreTaskArg, String> job(VisorSnapshotRestoreTaskArg arg) {
        VisorSnapshotRestoreTaskAction action = arg.jobAction() == null ? VisorSnapshotRestoreTaskAction.START : arg.jobAction();
        switch (action) {
            case START: {
                return new VisorSnapshotStartRestoreJob(arg, this.debug);
            }
            case CANCEL: {
                return new VisorSnapshotRestoreCancelJob(arg, this.debug);
            }
            case STATUS: {
                return new VisorSnapshotRestoreStatusJob(arg, this.debug);
            }
        }
        throw new IllegalArgumentException("Action is not supported: " + (Object)((Object)arg.jobAction()));
    }

    @Deprecated
    private static class VisorSnapshotRestoreStatusJob
    extends VisorSnapshotJob<VisorSnapshotRestoreTaskArg, String> {
        private static final long serialVersionUID = 0L;

        protected VisorSnapshotRestoreStatusJob(VisorSnapshotRestoreTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(VisorSnapshotRestoreTaskArg arg) throws IgniteException {
            boolean state = this.ignite.context().cache().context().snapshotMgr().restoreStatus(arg.snapshotName()).get();
            return "Snapshot cache group restore operation is " + (state ? "" : "NOT ") + "running [snapshot=" + arg.snapshotName() + ']';
        }
    }

    @Deprecated
    private static class VisorSnapshotRestoreCancelJob
    extends VisorSnapshotJob<VisorSnapshotRestoreTaskArg, String> {
        private static final long serialVersionUID = 0L;

        protected VisorSnapshotRestoreCancelJob(VisorSnapshotRestoreTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(VisorSnapshotRestoreTaskArg arg) throws IgniteException {
            boolean stopped = this.ignite.snapshot().cancelSnapshotRestore(arg.snapshotName()).get();
            return "Snapshot cache group restore operation " + (stopped ? "canceled" : "is NOT running") + " [snapshot=" + arg.snapshotName() + ']';
        }
    }

    private static class VisorSnapshotStartRestoreJob
    extends VisorSnapshotJob<VisorSnapshotRestoreTaskArg, String> {
        private static final long serialVersionUID = 0L;

        protected VisorSnapshotStartRestoreJob(VisorSnapshotRestoreTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(VisorSnapshotRestoreTaskArg arg) throws IgniteException {
            IgniteSnapshotManager.ClusterSnapshotFuture snpFut;
            IgniteFutureImpl<Void> fut = this.ignite.context().cache().context().snapshotMgr().restoreSnapshot(arg.snapshotName(), arg.snapshotPath(), arg.groupNames(), arg.incrementIndex(), arg.check());
            IgniteSnapshotManager.ClusterSnapshotFuture clusterSnapshotFuture = snpFut = fut.internalFuture() instanceof IgniteSnapshotManager.ClusterSnapshotFuture ? (IgniteSnapshotManager.ClusterSnapshotFuture)fut.internalFuture() : null;
            if (arg.sync() || fut.isDone()) {
                fut.get();
            }
            String msgSuff = arg.sync() ? "completed successfully" : "started";
            String msgGrps = arg.groupNames() == null ? "" : ", group(s)=" + F.concat(arg.groupNames(), ",");
            String msgId = snpFut != null && snpFut.requestId() != null ? ", id=" + snpFut.requestId() : "";
            return "Snapshot cache group restore operation " + msgSuff + " [name=" + arg.snapshotName() + msgGrps + msgId + ']';
        }
    }
}

