/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.loopback;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.ipc.IpcEndpointBindException;
import org.apache.ignite.internal.util.ipc.IpcServerEndpoint;
import org.apache.ignite.internal.util.ipc.loopback.IpcClientTcpEndpoint;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;

public class IpcServerTcpEndpoint
implements IpcServerEndpoint {
    public static final int DFLT_IPC_PORT = 10500;
    private ServerSocket srvSock;
    private int port = 10500;
    private String host;
    private boolean mgmt;
    @LoggerResource
    private IgniteLogger log;

    @Override
    public void start() throws IgniteCheckedException {
        if (this.port <= 0 || this.port >= 65535) {
            throw new IpcEndpointBindException("Port value is illegal: " + this.port);
        }
        try {
            this.srvSock = new ServerSocket();
            assert (this.host != null);
            this.srvSock.bind(new InetSocketAddress(U.resolveLocalHost(this.host), this.port));
            if (this.log.isInfoEnabled()) {
                this.log.info("IPC server loopback endpoint started [port=" + this.port + ']');
            }
        }
        catch (IOException e) {
            if (this.srvSock != null) {
                U.closeQuiet(this.srvSock);
            }
            throw new IpcEndpointBindException("Failed to bind loopback IPC endpoint (is port already in use?): " + this.port, e);
        }
    }

    @Override
    public IpcEndpoint accept() throws IgniteCheckedException {
        try {
            Socket sock = IgniteUtils.acceptServerSocket(this.srvSock);
            return new IpcClientTcpEndpoint(sock);
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public void close() {
        U.closeQuiet(this.srvSock);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public boolean isManagement() {
        return this.mgmt;
    }

    public void setManagement(boolean mgmt) {
        this.mgmt = mgmt;
    }

    public String toString() {
        return S.toString(IpcServerTcpEndpoint.class, this);
    }

    public void setupConfiguration(Map<String, String> endpointCfg) throws IgniteCheckedException {
        for (Map.Entry<String, String> e : endpointCfg.entrySet()) {
            try {
                switch (e.getKey()) {
                    case "type": {
                        break;
                    }
                    case "port": {
                        this.setPort(Integer.parseInt(e.getValue()));
                        break;
                    }
                    case "host": {
                        this.setHost(e.getValue());
                        break;
                    }
                    case "management": {
                        this.setManagement(Boolean.valueOf(e.getValue()));
                        break;
                    }
                    default: {
                        throw new IgniteCheckedException("Invalid property '" + e.getKey() + "' of " + this.getClass().getSimpleName());
                    }
                }
            }
            catch (Throwable t2) {
                if (t2 instanceof IgniteCheckedException || t2 instanceof Error) {
                    throw t2;
                }
                throw new IgniteCheckedException("Invalid value '" + e.getValue() + "' of the property '" + e.getKey() + "' in " + this.getClass().getSimpleName(), t2);
            }
        }
    }
}

