/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.DirectBufferCleaner;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.ReflectiveDirectBufferCleaner;
import org.apache.ignite.internal.util.UnsafeDirectBufferCleaner;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public abstract class GridUnsafe {
    public static final ByteOrder NATIVE_BYTE_ORDER;
    private static final Unsafe UNSAFE;
    private static final int PAGE_SIZE;
    private static final byte[] EMPTY_PAGE;
    private static final boolean UNALIGNED;
    public static final long DFLT_MEMORY_PER_BYTE_COPY_THRESHOLD = 0L;
    private static final long PER_BYTE_THRESHOLD;
    public static final boolean BIG_ENDIAN;
    public static final int ADDR_SIZE;
    public static final long BYTE_ARR_OFF;
    public static final int BYTE_ARR_INT_OFF;
    public static final long SHORT_ARR_OFF;
    public static final long INT_ARR_OFF;
    public static final long LONG_ARR_OFF;
    public static final long FLOAT_ARR_OFF;
    public static final long DOUBLE_ARR_OFF;
    public static final long CHAR_ARR_OFF;
    public static final long BOOLEAN_ARR_OFF;
    private static final long DIRECT_BUF_ADDR_OFF;
    private static final boolean IS_DIRECT_BUF_LONG_CAP;
    private static final DirectBufferCleaner DIRECT_BUF_CLEANER;
    @Nullable
    private static final Object JAVA_NIO_ACCESS_OBJ;
    @Nullable
    private static final Method NEW_DIRECT_BUF_MTD;
    @Nullable
    private static final Constructor<?> NEW_DIRECT_BUF_CONSTRUCTOR;

    private GridUnsafe() {
    }

    public static ByteBuffer wrapPointer(long ptr, int len) {
        if (NEW_DIRECT_BUF_MTD != null && JAVA_NIO_ACCESS_OBJ != null) {
            return GridUnsafe.wrapPointerJavaNio(ptr, len, NEW_DIRECT_BUF_MTD, JAVA_NIO_ACCESS_OBJ);
        }
        if (NEW_DIRECT_BUF_CONSTRUCTOR != null) {
            return GridUnsafe.wrapPointerDirectBufCtor(ptr, len, NEW_DIRECT_BUF_CONSTRUCTOR);
        }
        throw new RuntimeException("All alternative for a new DirectByteBuffer() creation failed: \nPlease add the following parameters to JVM startup settings and restart the application: {parameters: --add-exports=java.base/jdk.internal.misc=ALL-UNNAMED\n--add-exports=java.base/sun.nio.ch=ALL-UNNAMED\n--add-exports=java.management/com.sun.jmx.mbeanserver=ALL-UNNAMED\n--add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED\n--add-exports=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED\n--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED\n--illegal-access=permit\n}\nSee https://apacheignite.readme.io/docs/getting-started#section-running-ignite-with-java-9-10-11 for more information.");
    }

    @NotNull
    private static ByteBuffer wrapPointerDirectBufCtor(long ptr, int len, Constructor<?> constructor) {
        try {
            Object newDirectBuf = constructor.newInstance(ptr, len);
            return ((ByteBuffer)newDirectBuf).order(NATIVE_BYTE_ORDER);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("DirectByteBuffer#constructor is unavailable.\nPlease add the following parameters to JVM startup settings and restart the application: {parameters: --add-exports=java.base/jdk.internal.misc=ALL-UNNAMED\n--add-exports=java.base/sun.nio.ch=ALL-UNNAMED\n--add-exports=java.management/com.sun.jmx.mbeanserver=ALL-UNNAMED\n--add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED\n--add-exports=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED\n--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED\n--illegal-access=permit\n}\nSee https://apacheignite.readme.io/docs/getting-started#section-running-ignite-with-java-9-10-11 for more information.", e);
        }
    }

    @NotNull
    private static ByteBuffer wrapPointerJavaNio(long ptr, int len, @NotNull Method newDirectBufMtd, @NotNull Object javaNioAccessObj) {
        try {
            ByteBuffer buf = (ByteBuffer)newDirectBufMtd.invoke(javaNioAccessObj, ptr, len, null);
            Preconditions.checkState(buf.isDirect(), "buf.isDirect() is false");
            buf.order(NATIVE_BYTE_ORDER);
            return buf;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("JavaNioAccess#newDirectByteBuffer() method is unavailable.\nPlease add the following parameters to JVM startup settings and restart the application: {parameters: --add-exports=java.base/jdk.internal.misc=ALL-UNNAMED\n--add-exports=java.base/sun.nio.ch=ALL-UNNAMED\n--add-exports=java.management/com.sun.jmx.mbeanserver=ALL-UNNAMED\n--add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED\n--add-exports=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED\n--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED\n--illegal-access=permit\n}\nSee https://apacheignite.readme.io/docs/getting-started#section-running-ignite-with-java-9-10-11 for more information.", e);
        }
    }

    public static ByteBuffer allocateBuffer(int len) {
        long ptr = GridUnsafe.allocateMemory(len);
        return GridUnsafe.wrapPointer(ptr, len);
    }

    public static void freeBuffer(ByteBuffer buf) {
        long ptr = GridUnsafe.bufferAddress(buf);
        GridUnsafe.freeMemory(ptr);
    }

    public static ByteBuffer reallocateBuffer(ByteBuffer buf, int len) {
        long ptr = GridUnsafe.bufferAddress(buf);
        long newPtr = GridUnsafe.reallocateMemory(ptr, len);
        return GridUnsafe.wrapPointer(newPtr, len);
    }

    public static boolean getBooleanField(Object obj, long fieldOff) {
        return UNSAFE.getBoolean(obj, fieldOff);
    }

    public static void putBooleanField(Object obj, long fieldOff, boolean val) {
        UNSAFE.putBoolean(obj, fieldOff, val);
    }

    public static byte getByteField(Object obj, long fieldOff) {
        return UNSAFE.getByte(obj, fieldOff);
    }

    public static void putByteField(Object obj, long fieldOff, byte val) {
        UNSAFE.putByte(obj, fieldOff, val);
    }

    public static short getShortField(Object obj, long fieldOff) {
        return UNSAFE.getShort(obj, fieldOff);
    }

    public static void putShortField(Object obj, long fieldOff, short val) {
        UNSAFE.putShort(obj, fieldOff, val);
    }

    public static char getCharField(Object obj, long fieldOff) {
        return UNSAFE.getChar(obj, fieldOff);
    }

    public static void putCharField(Object obj, long fieldOff, char val) {
        UNSAFE.putChar(obj, fieldOff, val);
    }

    public static int getIntField(Object obj, long fieldOff) {
        return UNSAFE.getInt(obj, fieldOff);
    }

    public static void putIntField(Object obj, long fieldOff, int val) {
        UNSAFE.putInt(obj, fieldOff, val);
    }

    public static long getLongField(Object obj, long fieldOff) {
        return UNSAFE.getLong(obj, fieldOff);
    }

    public static void putLongField(Object obj, long fieldOff, long val) {
        UNSAFE.putLong(obj, fieldOff, val);
    }

    public static float getFloatField(Object obj, long fieldOff) {
        return UNSAFE.getFloat(obj, fieldOff);
    }

    public static void putFloatField(Object obj, long fieldOff, float val) {
        UNSAFE.putFloat(obj, fieldOff, val);
    }

    public static double getDoubleField(Object obj, long fieldOff) {
        return UNSAFE.getDouble(obj, fieldOff);
    }

    public static void putDoubleField(Object obj, long fieldOff, double val) {
        UNSAFE.putDouble(obj, fieldOff, val);
    }

    public static Object getObjectField(Object obj, long fieldOff) {
        return UNSAFE.getObject(obj, fieldOff);
    }

    public static void putObjectField(Object obj, long fieldOff, Object val) {
        UNSAFE.putObject(obj, fieldOff, val);
    }

    public static boolean getBoolean(byte[] arr, long off) {
        return UNSAFE.getBoolean(arr, off);
    }

    public static void putBoolean(byte[] arr, long off, boolean val) {
        UNSAFE.putBoolean(arr, off, val);
    }

    public static byte getByte(byte[] arr, long off) {
        return UNSAFE.getByte(arr, off);
    }

    public static void putByte(byte[] arr, long off, byte val) {
        UNSAFE.putByte(arr, off, val);
    }

    public static short getShort(byte[] arr, long off) {
        return UNALIGNED ? UNSAFE.getShort(arr, off) : GridUnsafe.getShortByByte(arr, off, BIG_ENDIAN);
    }

    public static void putShort(byte[] arr, long off, short val) {
        if (UNALIGNED) {
            UNSAFE.putShort(arr, off, val);
        } else {
            GridUnsafe.putShortByByte(arr, off, val, BIG_ENDIAN);
        }
    }

    public static char getChar(byte[] arr, long off) {
        return UNALIGNED ? UNSAFE.getChar(arr, off) : GridUnsafe.getCharByByte(arr, off, BIG_ENDIAN);
    }

    public static void putChar(byte[] arr, long off, char val) {
        if (UNALIGNED) {
            UNSAFE.putChar(arr, off, val);
        } else {
            GridUnsafe.putCharByByte(arr, off, val, BIG_ENDIAN);
        }
    }

    public static int getInt(byte[] arr, long off) {
        return UNALIGNED ? UNSAFE.getInt(arr, off) : GridUnsafe.getIntByByte(arr, off, BIG_ENDIAN);
    }

    public static void putInt(byte[] arr, long off, int val) {
        if (UNALIGNED) {
            UNSAFE.putInt(arr, off, val);
        } else {
            GridUnsafe.putIntByByte(arr, off, val, BIG_ENDIAN);
        }
    }

    public static long getLong(byte[] arr, long off) {
        return UNALIGNED ? UNSAFE.getLong(arr, off) : GridUnsafe.getLongByByte(arr, off, BIG_ENDIAN);
    }

    public static void putLong(byte[] arr, long off, long val) {
        if (UNALIGNED) {
            UNSAFE.putLong(arr, off, val);
        } else {
            GridUnsafe.putLongByByte(arr, off, val, BIG_ENDIAN);
        }
    }

    public static float getFloat(byte[] arr, long off) {
        return UNALIGNED ? UNSAFE.getFloat(arr, off) : Float.intBitsToFloat(GridUnsafe.getIntByByte(arr, off, BIG_ENDIAN));
    }

    public static void putFloat(byte[] arr, long off, float val) {
        if (UNALIGNED) {
            UNSAFE.putFloat(arr, off, val);
        } else {
            GridUnsafe.putIntByByte(arr, off, Float.floatToIntBits(val), BIG_ENDIAN);
        }
    }

    public static double getDouble(byte[] arr, long off) {
        return UNALIGNED ? UNSAFE.getDouble(arr, off) : Double.longBitsToDouble(GridUnsafe.getLongByByte(arr, off, BIG_ENDIAN));
    }

    public static void putDouble(byte[] arr, long off, double val) {
        if (UNALIGNED) {
            UNSAFE.putDouble(arr, off, val);
        } else {
            GridUnsafe.putLongByByte(arr, off, Double.doubleToLongBits(val), BIG_ENDIAN);
        }
    }

    public static short getShortLE(byte[] arr, long off) {
        return UNALIGNED ? Short.reverseBytes(UNSAFE.getShort(arr, off)) : GridUnsafe.getShortByByte(arr, off, false);
    }

    public static void putShortLE(byte[] arr, long off, short val) {
        if (UNALIGNED) {
            UNSAFE.putShort(arr, off, Short.reverseBytes(val));
        } else {
            GridUnsafe.putShortByByte(arr, off, val, false);
        }
    }

    public static char getCharLE(byte[] arr, long off) {
        return UNALIGNED ? Character.reverseBytes(UNSAFE.getChar(arr, off)) : GridUnsafe.getCharByByte(arr, off, false);
    }

    public static void putCharLE(byte[] arr, long off, char val) {
        if (UNALIGNED) {
            UNSAFE.putChar(arr, off, Character.reverseBytes(val));
        } else {
            GridUnsafe.putCharByByte(arr, off, val, false);
        }
    }

    public static int getIntLE(byte[] arr, long off) {
        return UNALIGNED ? Integer.reverseBytes(UNSAFE.getInt(arr, off)) : GridUnsafe.getIntByByte(arr, off, false);
    }

    public static void putIntLE(byte[] arr, long off, int val) {
        if (UNALIGNED) {
            UNSAFE.putInt(arr, off, Integer.reverseBytes(val));
        } else {
            GridUnsafe.putIntByByte(arr, off, val, false);
        }
    }

    public static long getLongLE(byte[] arr, long off) {
        return UNALIGNED ? Long.reverseBytes(UNSAFE.getLong(arr, off)) : GridUnsafe.getLongByByte(arr, off, false);
    }

    public static void putLongLE(byte[] arr, long off, long val) {
        if (UNALIGNED) {
            UNSAFE.putLong(arr, off, Long.reverseBytes(val));
        } else {
            GridUnsafe.putLongByByte(arr, off, val, false);
        }
    }

    public static float getFloatLE(byte[] arr, long off) {
        return Float.intBitsToFloat(UNALIGNED ? Integer.reverseBytes(UNSAFE.getInt(arr, off)) : GridUnsafe.getIntByByte(arr, off, false));
    }

    public static void putFloatLE(byte[] arr, long off, float val) {
        int intVal = Float.floatToIntBits(val);
        if (UNALIGNED) {
            UNSAFE.putInt(arr, off, Integer.reverseBytes(intVal));
        } else {
            GridUnsafe.putIntByByte(arr, off, intVal, false);
        }
    }

    public static double getDoubleLE(byte[] arr, long off) {
        return Double.longBitsToDouble(UNALIGNED ? Long.reverseBytes(UNSAFE.getLong(arr, off)) : GridUnsafe.getLongByByte(arr, off, false));
    }

    public static void putDoubleLE(byte[] arr, long off, double val) {
        long longVal = Double.doubleToLongBits(val);
        if (UNALIGNED) {
            UNSAFE.putLong(arr, off, Long.reverseBytes(longVal));
        } else {
            GridUnsafe.putLongByByte(arr, off, longVal, false);
        }
    }

    public static byte getByte(long addr) {
        return UNSAFE.getByte(addr);
    }

    public static void putByte(long addr, byte val) {
        UNSAFE.putByte(addr, val);
    }

    public static short getShort(long addr) {
        return UNALIGNED ? UNSAFE.getShort(addr) : GridUnsafe.getShortByByte(addr, BIG_ENDIAN);
    }

    public static void putShort(long addr, short val) {
        if (UNALIGNED) {
            UNSAFE.putShort(addr, val);
        } else {
            GridUnsafe.putShortByByte(addr, val, BIG_ENDIAN);
        }
    }

    public static char getChar(long addr) {
        return UNALIGNED ? UNSAFE.getChar(addr) : GridUnsafe.getCharByByte(addr, BIG_ENDIAN);
    }

    public static void putChar(long addr, char val) {
        if (UNALIGNED) {
            UNSAFE.putChar(addr, val);
        } else {
            GridUnsafe.putCharByByte(addr, val, BIG_ENDIAN);
        }
    }

    public static int getInt(long addr) {
        return UNALIGNED ? UNSAFE.getInt(addr) : GridUnsafe.getIntByByte(addr, BIG_ENDIAN);
    }

    public static void putInt(long addr, int val) {
        if (UNALIGNED) {
            UNSAFE.putInt(addr, val);
        } else {
            GridUnsafe.putIntByByte(addr, val, BIG_ENDIAN);
        }
    }

    public static long getLong(long addr) {
        return UNALIGNED ? UNSAFE.getLong(addr) : GridUnsafe.getLongByByte(addr, BIG_ENDIAN);
    }

    public static void putLong(long addr, long val) {
        if (UNALIGNED) {
            UNSAFE.putLong(addr, val);
        } else {
            GridUnsafe.putLongByByte(addr, val, BIG_ENDIAN);
        }
    }

    public static float getFloat(long addr) {
        return UNALIGNED ? UNSAFE.getFloat(addr) : Float.intBitsToFloat(GridUnsafe.getIntByByte(addr, BIG_ENDIAN));
    }

    public static void putFloat(long addr, float val) {
        if (UNALIGNED) {
            UNSAFE.putFloat(addr, val);
        } else {
            GridUnsafe.putIntByByte(addr, Float.floatToIntBits(val), BIG_ENDIAN);
        }
    }

    public static double getDouble(long addr) {
        return UNALIGNED ? UNSAFE.getDouble(addr) : Double.longBitsToDouble(GridUnsafe.getLongByByte(addr, BIG_ENDIAN));
    }

    public static void putDouble(long addr, double val) {
        if (UNALIGNED) {
            UNSAFE.putDouble(addr, val);
        } else {
            GridUnsafe.putLongByByte(addr, Double.doubleToLongBits(val), BIG_ENDIAN);
        }
    }

    public static short getShortLE(long addr) {
        return UNALIGNED ? Short.reverseBytes(UNSAFE.getShort(addr)) : GridUnsafe.getShortByByte(addr, false);
    }

    public static void putShortLE(long addr, short val) {
        if (UNALIGNED) {
            UNSAFE.putShort(addr, Short.reverseBytes(val));
        } else {
            GridUnsafe.putShortByByte(addr, val, false);
        }
    }

    public static char getCharLE(long addr) {
        return UNALIGNED ? Character.reverseBytes(UNSAFE.getChar(addr)) : GridUnsafe.getCharByByte(addr, false);
    }

    public static void putCharLE(long addr, char val) {
        if (UNALIGNED) {
            UNSAFE.putChar(addr, Character.reverseBytes(val));
        } else {
            GridUnsafe.putCharByByte(addr, val, false);
        }
    }

    public static int getIntLE(long addr) {
        return UNALIGNED ? Integer.reverseBytes(UNSAFE.getInt(addr)) : GridUnsafe.getIntByByte(addr, false);
    }

    public static void putIntLE(long addr, int val) {
        if (UNALIGNED) {
            UNSAFE.putInt(addr, Integer.reverseBytes(val));
        } else {
            GridUnsafe.putIntByByte(addr, val, false);
        }
    }

    public static long getLongLE(long addr) {
        return UNALIGNED ? Long.reverseBytes(UNSAFE.getLong(addr)) : GridUnsafe.getLongByByte(addr, false);
    }

    public static void putLongLE(long addr, long val) {
        if (UNALIGNED) {
            UNSAFE.putLong(addr, Long.reverseBytes(val));
        } else {
            GridUnsafe.putLongByByte(addr, val, false);
        }
    }

    public static float getFloatLE(long addr) {
        return Float.intBitsToFloat(UNALIGNED ? Integer.reverseBytes(UNSAFE.getInt(addr)) : GridUnsafe.getIntByByte(addr, false));
    }

    public static void putFloatLE(long addr, float val) {
        int intVal = Float.floatToIntBits(val);
        if (UNALIGNED) {
            UNSAFE.putInt(addr, Integer.reverseBytes(intVal));
        } else {
            GridUnsafe.putIntByByte(addr, intVal, false);
        }
    }

    public static double getDoubleLE(long addr) {
        return Double.longBitsToDouble(UNALIGNED ? Long.reverseBytes(UNSAFE.getLong(addr)) : GridUnsafe.getLongByByte(addr, false));
    }

    public static void putDoubleLE(long addr, double val) {
        long longVal = Double.doubleToLongBits(val);
        if (UNALIGNED) {
            UNSAFE.putLong(addr, Long.reverseBytes(longVal));
        } else {
            GridUnsafe.putLongByByte(addr, longVal, false);
        }
    }

    public static long staticFieldOffset(Field field) {
        return UNSAFE.staticFieldOffset(field);
    }

    public static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    public static Object staticFieldBase(Field field) {
        return UNSAFE.staticFieldBase(field);
    }

    public static long allocateMemory(long size) {
        return UNSAFE.allocateMemory(size);
    }

    public static long reallocateMemory(long addr, long len) {
        return UNSAFE.reallocateMemory(addr, len);
    }

    public static void setMemory(long addr, long len, byte val) {
        UNSAFE.setMemory(addr, len, val);
    }

    public static void zeroMemory(long addr, long len) {
        long off = 0L;
        while (off + (long)PAGE_SIZE <= len) {
            UNSAFE.copyMemory(EMPTY_PAGE, BYTE_ARR_OFF, null, addr + off, PAGE_SIZE);
            off += (long)PAGE_SIZE;
        }
        if (len != off) {
            UNSAFE.copyMemory(EMPTY_PAGE, BYTE_ARR_OFF, null, addr + off, len - off);
        }
    }

    public static void copyOffheapOffheap(long srcAddr, long dstAddr, long len) {
        if (len <= PER_BYTE_THRESHOLD) {
            int i = 0;
            while ((long)i < len) {
                UNSAFE.putByte(dstAddr + (long)i, UNSAFE.getByte(srcAddr + (long)i));
                ++i;
            }
        } else {
            UNSAFE.copyMemory(srcAddr, dstAddr, len);
        }
    }

    public static void copyOffheapHeap(long srcAddr, Object dstBase, long dstOff, long len) {
        if (len <= PER_BYTE_THRESHOLD) {
            int i = 0;
            while ((long)i < len) {
                UNSAFE.putByte(dstBase, dstOff + (long)i, UNSAFE.getByte(srcAddr + (long)i));
                ++i;
            }
        } else {
            UNSAFE.copyMemory(null, srcAddr, dstBase, dstOff, len);
        }
    }

    public static void copyHeapOffheap(Object srcBase, long srcOff, long dstAddr, long len) {
        if (len <= PER_BYTE_THRESHOLD) {
            int i = 0;
            while ((long)i < len) {
                UNSAFE.putByte(dstAddr + (long)i, UNSAFE.getByte(srcBase, srcOff + (long)i));
                ++i;
            }
        } else {
            UNSAFE.copyMemory(srcBase, srcOff, null, dstAddr, len);
        }
    }

    public static void copyMemory(long src, long dst, long len) {
        UNSAFE.copyMemory(src, dst, len);
    }

    public static void copyMemory(Object srcBase, long srcOff, Object dstBase, long dstOff, long len) {
        if (len <= PER_BYTE_THRESHOLD && srcBase != null && dstBase != null) {
            int i = 0;
            while ((long)i < len) {
                UNSAFE.putByte(dstBase, dstOff + (long)i, UNSAFE.getByte(srcBase, srcOff + (long)i));
                ++i;
            }
        } else {
            UNSAFE.copyMemory(srcBase, srcOff, dstBase, dstOff, len);
        }
    }

    public static void freeMemory(long addr) {
        UNSAFE.freeMemory(addr);
    }

    public static int arrayBaseOffset(Class cls) {
        return UNSAFE.arrayBaseOffset(cls);
    }

    public static int arrayIndexScale(Class<?> cls) {
        return UNSAFE.arrayIndexScale(cls);
    }

    public static Object allocateInstance(Class cls) throws InstantiationException {
        return UNSAFE.allocateInstance(cls);
    }

    public static boolean compareAndSwapInt(Object obj, long off, int exp, int upd) {
        return UNSAFE.compareAndSwapInt(obj, off, exp, upd);
    }

    public static boolean compareAndSwapLong(Object obj, long off, long exp, long upd) {
        return UNSAFE.compareAndSwapLong(obj, off, exp, upd);
    }

    public static int incrementAndGetInt(long ptr) {
        return UNSAFE.getAndAddInt(null, ptr, 1) + 1;
    }

    public static int decrementAndGetInt(long ptr) {
        return UNSAFE.getAndAddInt(null, ptr, -1) - 1;
    }

    public static byte getByteVolatile(Object obj, long off) {
        return UNSAFE.getByteVolatile(obj, off);
    }

    public static void putByteVolatile(Object obj, long off, byte val) {
        UNSAFE.putByteVolatile(obj, off, val);
    }

    public static int getIntVolatile(Object obj, long off) {
        return UNSAFE.getIntVolatile(obj, off);
    }

    public static void putIntVolatile(Object obj, long off, int val) {
        UNSAFE.putIntVolatile(obj, off, val);
    }

    public static long getLongVolatile(Object obj, long off) {
        return UNSAFE.getLongVolatile(obj, off);
    }

    public static void putLongVolatile(Object obj, long off, long val) {
        UNSAFE.putLongVolatile(obj, off, val);
    }

    public static void putObjectVolatile(Object obj, long off, Object val) {
        UNSAFE.putObjectVolatile(obj, off, val);
    }

    public static int pageSize() {
        return UNSAFE.pageSize();
    }

    public static long bufferAddress(ByteBuffer buf) {
        Preconditions.checkState(buf.isDirect(), "buf.isDirect() is false");
        return UNSAFE.getLong(buf, DIRECT_BUF_ADDR_OFF);
    }

    public static Object invoke(Method mtd, Object ... args) {
        try {
            return mtd.invoke((Object)UNSAFE, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unsafe invocation failed [cls=" + UNSAFE.getClass() + ", mtd=" + mtd + "]", e);
        }
    }

    public static void cleanDirectBuffer(ByteBuffer buf) {
        Preconditions.checkState(buf.isDirect(), "buf.isDirect() is false");
        DIRECT_BUF_CLEANER.clean(buf);
    }

    private static boolean unaligned() {
        boolean res;
        String arch = System.getProperty("os.arch");
        boolean bl = res = arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64");
        if (!res) {
            res = IgniteSystemProperties.getBoolean("IGNITE_MEMORY_UNALIGNED_ACCESS", false);
        }
        return res;
    }

    private static Unsafe unsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException ignored) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics.", e.getCause());
            }
        }
    }

    private static long bufferAddressOffset() {
        final ByteBuffer maybeDirectBuf = ByteBuffer.allocateDirect(1);
        Field addrField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field addrFld = Buffer.class.getDeclaredField("address");
                    addrFld.setAccessible(true);
                    if (addrFld.getLong(maybeDirectBuf) == 0L) {
                        throw new RuntimeException("java.nio.DirectByteBuffer.address field is unavailable.");
                    }
                    return addrFld;
                }
                catch (Exception e) {
                    throw new RuntimeException("java.nio.DirectByteBuffer.address field is unavailable.", e);
                }
            }
        });
        return UNSAFE.objectFieldOffset(addrField);
    }

    private static Object javaNioAccessObject() {
        String pkgName = GridUnsafe.miscPackage();
        try {
            Class<?> cls = Class.forName(pkgName + ".misc.SharedSecrets");
            Method mth = cls.getMethod("getJavaNioAccess", new Class[0]);
            return mth.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(pkgName + ".misc.JavaNioAccess class is unavailable.\nPlease add the following parameters to JVM startup settings and restart the application: {parameters: --add-exports=java.base/jdk.internal.misc=ALL-UNNAMED\n--add-exports=java.base/sun.nio.ch=ALL-UNNAMED\n--add-exports=java.management/com.sun.jmx.mbeanserver=ALL-UNNAMED\n--add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED\n--add-exports=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED\n--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED\n--illegal-access=permit\n}\nSee https://apacheignite.readme.io/docs/getting-started#section-running-ignite-with-java-9-10-11 for more information.", e);
        }
    }

    private static Method newDirectBufferMethod(Object nioAccessObj) {
        try {
            Class<?> cls = nioAccessObj.getClass();
            Method mtd = IS_DIRECT_BUF_LONG_CAP ? cls.getMethod("newDirectByteBuffer", Long.TYPE, Long.TYPE, Object.class) : cls.getMethod("newDirectByteBuffer", Long.TYPE, Integer.TYPE, Object.class);
            mtd.setAccessible(true);
            return mtd;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(GridUnsafe.miscPackage() + ".JavaNioAccess#newDirectByteBuffer() method is unavailable.\nPlease add the following parameters to JVM startup settings and restart the application: {parameters: --add-exports=java.base/jdk.internal.misc=ALL-UNNAMED\n--add-exports=java.base/sun.nio.ch=ALL-UNNAMED\n--add-exports=java.management/com.sun.jmx.mbeanserver=ALL-UNNAMED\n--add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED\n--add-exports=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED\n--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED\n--illegal-access=permit\n}\nSee https://apacheignite.readme.io/docs/getting-started#section-running-ignite-with-java-9-10-11 for more information.", e);
        }
    }

    @NotNull
    private static String miscPackage() {
        int javaVer = IgniteUtils.majorJavaVersion(IgniteUtils.jdkVersion());
        return javaVer < 9 ? "sun" : "jdk.internal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Constructor<?> createAndTestNewDirectBufferCtor() {
        Constructor<?> ctorCandidate = GridUnsafe.createNewDirectBufferCtor();
        int l = 1;
        long ptr = UNSAFE.allocateMemory(l);
        try {
            ByteBuffer buf = GridUnsafe.wrapPointerDirectBufCtor(ptr, l, ctorCandidate);
            A.ensure(buf.isDirect(), "Buffer expected to be direct, internal error during #wrapPointerDirectBufCtor()");
        }
        finally {
            UNSAFE.freeMemory(ptr);
        }
        return ctorCandidate;
    }

    @NotNull
    private static Constructor<?> createNewDirectBufferCtor() {
        try {
            ByteBuffer buf = ByteBuffer.allocateDirect(1).order(NATIVE_BYTE_ORDER);
            Constructor<?> ctor = IS_DIRECT_BUF_LONG_CAP ? buf.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE) : buf.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Unable to set up byte buffer creation using reflections :" + e.getMessage(), e);
        }
    }

    private static short getShortByByte(Object obj, long off, boolean bigEndian) {
        if (bigEndian) {
            return (short)(UNSAFE.getByte(obj, off) << 8 | UNSAFE.getByte(obj, off + 1L) & 0xFF);
        }
        return (short)(UNSAFE.getByte(obj, off + 1L) << 8 | UNSAFE.getByte(obj, off) & 0xFF);
    }

    private static void putShortByByte(Object obj, long off, short val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(obj, off, (byte)(val >> 8));
            UNSAFE.putByte(obj, off + 1L, (byte)val);
        } else {
            UNSAFE.putByte(obj, off + 1L, (byte)(val >> 8));
            UNSAFE.putByte(obj, off, (byte)val);
        }
    }

    private static char getCharByByte(Object obj, long off, boolean bigEndian) {
        if (bigEndian) {
            return (char)(UNSAFE.getByte(obj, off) << 8 | UNSAFE.getByte(obj, off + 1L) & 0xFF);
        }
        return (char)(UNSAFE.getByte(obj, off + 1L) << 8 | UNSAFE.getByte(obj, off) & 0xFF);
    }

    private static void putCharByByte(Object obj, long addr, char val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(obj, addr, (byte)(val >> 8));
            UNSAFE.putByte(obj, addr + 1L, (byte)val);
        } else {
            UNSAFE.putByte(obj, addr + 1L, (byte)(val >> 8));
            UNSAFE.putByte(obj, addr, (byte)val);
        }
    }

    private static int getIntByByte(Object obj, long addr, boolean bigEndian) {
        if (bigEndian) {
            return UNSAFE.getByte(obj, addr) << 24 | (UNSAFE.getByte(obj, addr + 1L) & 0xFF) << 16 | (UNSAFE.getByte(obj, addr + 2L) & 0xFF) << 8 | UNSAFE.getByte(obj, addr + 3L) & 0xFF;
        }
        return UNSAFE.getByte(obj, addr + 3L) << 24 | (UNSAFE.getByte(obj, addr + 2L) & 0xFF) << 16 | (UNSAFE.getByte(obj, addr + 1L) & 0xFF) << 8 | UNSAFE.getByte(obj, addr) & 0xFF;
    }

    private static void putIntByByte(Object obj, long addr, int val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(obj, addr, (byte)(val >> 24));
            UNSAFE.putByte(obj, addr + 1L, (byte)(val >> 16));
            UNSAFE.putByte(obj, addr + 2L, (byte)(val >> 8));
            UNSAFE.putByte(obj, addr + 3L, (byte)val);
        } else {
            UNSAFE.putByte(obj, addr + 3L, (byte)(val >> 24));
            UNSAFE.putByte(obj, addr + 2L, (byte)(val >> 16));
            UNSAFE.putByte(obj, addr + 1L, (byte)(val >> 8));
            UNSAFE.putByte(obj, addr, (byte)val);
        }
    }

    private static long getLongByByte(Object obj, long addr, boolean bigEndian) {
        if (bigEndian) {
            return (long)UNSAFE.getByte(obj, addr) << 56 | ((long)UNSAFE.getByte(obj, addr + 1L) & 0xFFL) << 48 | ((long)UNSAFE.getByte(obj, addr + 2L) & 0xFFL) << 40 | ((long)UNSAFE.getByte(obj, addr + 3L) & 0xFFL) << 32 | ((long)UNSAFE.getByte(obj, addr + 4L) & 0xFFL) << 24 | ((long)UNSAFE.getByte(obj, addr + 5L) & 0xFFL) << 16 | ((long)UNSAFE.getByte(obj, addr + 6L) & 0xFFL) << 8 | (long)UNSAFE.getByte(obj, addr + 7L) & 0xFFL;
        }
        return (long)UNSAFE.getByte(obj, addr + 7L) << 56 | ((long)UNSAFE.getByte(obj, addr + 6L) & 0xFFL) << 48 | ((long)UNSAFE.getByte(obj, addr + 5L) & 0xFFL) << 40 | ((long)UNSAFE.getByte(obj, addr + 4L) & 0xFFL) << 32 | ((long)UNSAFE.getByte(obj, addr + 3L) & 0xFFL) << 24 | ((long)UNSAFE.getByte(obj, addr + 2L) & 0xFFL) << 16 | ((long)UNSAFE.getByte(obj, addr + 1L) & 0xFFL) << 8 | (long)UNSAFE.getByte(obj, addr) & 0xFFL;
    }

    private static void putLongByByte(Object obj, long addr, long val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(obj, addr, (byte)(val >> 56));
            UNSAFE.putByte(obj, addr + 1L, (byte)(val >> 48));
            UNSAFE.putByte(obj, addr + 2L, (byte)(val >> 40));
            UNSAFE.putByte(obj, addr + 3L, (byte)(val >> 32));
            UNSAFE.putByte(obj, addr + 4L, (byte)(val >> 24));
            UNSAFE.putByte(obj, addr + 5L, (byte)(val >> 16));
            UNSAFE.putByte(obj, addr + 6L, (byte)(val >> 8));
            UNSAFE.putByte(obj, addr + 7L, (byte)val);
        } else {
            UNSAFE.putByte(obj, addr + 7L, (byte)(val >> 56));
            UNSAFE.putByte(obj, addr + 6L, (byte)(val >> 48));
            UNSAFE.putByte(obj, addr + 5L, (byte)(val >> 40));
            UNSAFE.putByte(obj, addr + 4L, (byte)(val >> 32));
            UNSAFE.putByte(obj, addr + 3L, (byte)(val >> 24));
            UNSAFE.putByte(obj, addr + 2L, (byte)(val >> 16));
            UNSAFE.putByte(obj, addr + 1L, (byte)(val >> 8));
            UNSAFE.putByte(obj, addr, (byte)val);
        }
    }

    private static short getShortByByte(long addr, boolean bigEndian) {
        if (bigEndian) {
            return (short)(UNSAFE.getByte(addr) << 8 | UNSAFE.getByte(addr + 1L) & 0xFF);
        }
        return (short)(UNSAFE.getByte(addr + 1L) << 8 | UNSAFE.getByte(addr) & 0xFF);
    }

    private static void putShortByByte(long addr, short val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(addr, (byte)(val >> 8));
            UNSAFE.putByte(addr + 1L, (byte)val);
        } else {
            UNSAFE.putByte(addr + 1L, (byte)(val >> 8));
            UNSAFE.putByte(addr, (byte)val);
        }
    }

    private static char getCharByByte(long addr, boolean bigEndian) {
        if (bigEndian) {
            return (char)(UNSAFE.getByte(addr) << 8 | UNSAFE.getByte(addr + 1L) & 0xFF);
        }
        return (char)(UNSAFE.getByte(addr + 1L) << 8 | UNSAFE.getByte(addr) & 0xFF);
    }

    private static void putCharByByte(long addr, char val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(addr, (byte)(val >> 8));
            UNSAFE.putByte(addr + 1L, (byte)val);
        } else {
            UNSAFE.putByte(addr + 1L, (byte)(val >> 8));
            UNSAFE.putByte(addr, (byte)val);
        }
    }

    private static int getIntByByte(long addr, boolean bigEndian) {
        if (bigEndian) {
            return UNSAFE.getByte(addr) << 24 | (UNSAFE.getByte(addr + 1L) & 0xFF) << 16 | (UNSAFE.getByte(addr + 2L) & 0xFF) << 8 | UNSAFE.getByte(addr + 3L) & 0xFF;
        }
        return UNSAFE.getByte(addr + 3L) << 24 | (UNSAFE.getByte(addr + 2L) & 0xFF) << 16 | (UNSAFE.getByte(addr + 1L) & 0xFF) << 8 | UNSAFE.getByte(addr) & 0xFF;
    }

    private static void putIntByByte(long addr, int val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(addr, (byte)(val >> 24));
            UNSAFE.putByte(addr + 1L, (byte)(val >> 16));
            UNSAFE.putByte(addr + 2L, (byte)(val >> 8));
            UNSAFE.putByte(addr + 3L, (byte)val);
        } else {
            UNSAFE.putByte(addr + 3L, (byte)(val >> 24));
            UNSAFE.putByte(addr + 2L, (byte)(val >> 16));
            UNSAFE.putByte(addr + 1L, (byte)(val >> 8));
            UNSAFE.putByte(addr, (byte)val);
        }
    }

    private static long getLongByByte(long addr, boolean bigEndian) {
        if (bigEndian) {
            return (long)UNSAFE.getByte(addr) << 56 | ((long)UNSAFE.getByte(addr + 1L) & 0xFFL) << 48 | ((long)UNSAFE.getByte(addr + 2L) & 0xFFL) << 40 | ((long)UNSAFE.getByte(addr + 3L) & 0xFFL) << 32 | ((long)UNSAFE.getByte(addr + 4L) & 0xFFL) << 24 | ((long)UNSAFE.getByte(addr + 5L) & 0xFFL) << 16 | ((long)UNSAFE.getByte(addr + 6L) & 0xFFL) << 8 | (long)UNSAFE.getByte(addr + 7L) & 0xFFL;
        }
        return (long)UNSAFE.getByte(addr + 7L) << 56 | ((long)UNSAFE.getByte(addr + 6L) & 0xFFL) << 48 | ((long)UNSAFE.getByte(addr + 5L) & 0xFFL) << 40 | ((long)UNSAFE.getByte(addr + 4L) & 0xFFL) << 32 | ((long)UNSAFE.getByte(addr + 3L) & 0xFFL) << 24 | ((long)UNSAFE.getByte(addr + 2L) & 0xFFL) << 16 | ((long)UNSAFE.getByte(addr + 1L) & 0xFFL) << 8 | (long)UNSAFE.getByte(addr) & 0xFFL;
    }

    private static void putLongByByte(long addr, long val, boolean bigEndian) {
        if (bigEndian) {
            UNSAFE.putByte(addr, (byte)(val >> 56));
            UNSAFE.putByte(addr + 1L, (byte)(val >> 48));
            UNSAFE.putByte(addr + 2L, (byte)(val >> 40));
            UNSAFE.putByte(addr + 3L, (byte)(val >> 32));
            UNSAFE.putByte(addr + 4L, (byte)(val >> 24));
            UNSAFE.putByte(addr + 5L, (byte)(val >> 16));
            UNSAFE.putByte(addr + 6L, (byte)(val >> 8));
            UNSAFE.putByte(addr + 7L, (byte)val);
        } else {
            UNSAFE.putByte(addr + 7L, (byte)(val >> 56));
            UNSAFE.putByte(addr + 6L, (byte)(val >> 48));
            UNSAFE.putByte(addr + 5L, (byte)(val >> 40));
            UNSAFE.putByte(addr + 4L, (byte)(val >> 32));
            UNSAFE.putByte(addr + 3L, (byte)(val >> 24));
            UNSAFE.putByte(addr + 2L, (byte)(val >> 16));
            UNSAFE.putByte(addr + 1L, (byte)(val >> 8));
            UNSAFE.putByte(addr, (byte)val);
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block10: {
            GridUnsafe.NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
            GridUnsafe.UNSAFE = GridUnsafe.unsafe();
            GridUnsafe.PAGE_SIZE = GridUnsafe.UNSAFE.pageSize();
            GridUnsafe.EMPTY_PAGE = new byte[GridUnsafe.PAGE_SIZE];
            GridUnsafe.UNALIGNED = GridUnsafe.unaligned();
            GridUnsafe.PER_BYTE_THRESHOLD = IgniteSystemProperties.getLong("IGNITE_MEMORY_PER_BYTE_COPY_THRESHOLD", 0L);
            GridUnsafe.BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
            GridUnsafe.ADDR_SIZE = GridUnsafe.UNSAFE.addressSize();
            GridUnsafe.BYTE_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(byte[].class);
            GridUnsafe.BYTE_ARR_INT_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(byte[].class);
            GridUnsafe.SHORT_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(short[].class);
            GridUnsafe.INT_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(int[].class);
            GridUnsafe.LONG_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(long[].class);
            GridUnsafe.FLOAT_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(float[].class);
            GridUnsafe.DOUBLE_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(double[].class);
            GridUnsafe.CHAR_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(char[].class);
            GridUnsafe.BOOLEAN_ARR_OFF = GridUnsafe.UNSAFE.arrayBaseOffset(boolean[].class);
            GridUnsafe.DIRECT_BUF_ADDR_OFF = GridUnsafe.bufferAddressOffset();
            GridUnsafe.IS_DIRECT_BUF_LONG_CAP = IgniteUtils.majorJavaVersion(IgniteUtils.jdkVersion()) >= 21;
            GridUnsafe.DIRECT_BUF_CLEANER = IgniteUtils.majorJavaVersion(IgniteUtils.jdkVersion()) < 9 ? new ReflectiveDirectBufferCleaner() : new UnsafeDirectBufferCleaner();
            nioAccessObj = null;
            directBufMtd = null;
            directBufCtor = null;
            if (IgniteUtils.majorJavaVersion(IgniteUtils.jdkVersion()) < 12) {
                try {
                    nioAccessObj = GridUnsafe.javaNioAccessObject();
                    directBufMtd = GridUnsafe.newDirectBufferMethod(nioAccessObj);
                }
                catch (Exception e) {
                    nioAccessObj = null;
                    directBufMtd = null;
                    try {
                        directBufCtor = GridUnsafe.createAndTestNewDirectBufferCtor();
                    }
                    catch (Exception eFallback) {
                        eFallback.printStackTrace();
                        e.addSuppressed(eFallback);
                        throw e;
                    }
                    if (directBufCtor != null) ** GOTO lbl55
                    throw e;
                }
            } else {
                try {
                    directBufCtor = GridUnsafe.createAndTestNewDirectBufferCtor();
                }
                catch (Exception e) {
                    try {
                        nioAccessObj = GridUnsafe.javaNioAccessObject();
                        directBufMtd = GridUnsafe.newDirectBufferMethod(nioAccessObj);
                    }
                    catch (Exception eFallback) {
                        eFallback.printStackTrace();
                        e.addSuppressed(eFallback);
                        throw e;
                    }
                    if (nioAccessObj != null && directBufMtd != null) break block10;
                    throw e;
                }
            }
        }
        GridUnsafe.JAVA_NIO_ACCESS_OBJ = nioAccessObj;
        GridUnsafe.NEW_DIRECT_BUF_MTD = directBufMtd;
        GridUnsafe.NEW_DIRECT_BUF_CONSTRUCTOR = directBufCtor;
    }
}

